/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.multiblock;

import elec332.core.compat.handlers.WailaCompatHandler;
import elec332.core.main.ElecCore;
import elec332.core.multiblock.AbstractMultiBlock;
import elec332.core.multiblock.IMultiBlock;
import elec332.core.multiblock.IMultiBlockTile;
import elec332.core.multiblock.MultiBlockData;
import elec332.core.multiblock.MultiBlockRegistry;
import elec332.core.tile.IInventoryTile;
import elec332.core.tile.TileBase;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public abstract class AbstractMultiBlockTile
extends TileBase
implements IMultiBlockTile,
IInventoryTile,
WailaCompatHandler.IWailaInfoTile {
    private MultiBlockData multiBlockData;

    public AbstractMultiBlockTile(MultiBlockRegistry registry) {
        this.multiBlockData = new MultiBlockData(this, registry);
    }

    @Override
    public boolean onBlockActivated(IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.getMultiBlock() == null ? this.onBlockActivatedBy(state, player, hand, stack, side, hitX, hitY, hitZ) : this.getMultiBlock().onAnyBlockActivated(player, hand, stack, this.field_174879_c, state);
    }

    public boolean onBlockActivatedBy(IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.multiBlockData.writeToNBT(tagCompound);
        if (this.getMultiBlock() != null && this.getMultiBlock().isSaveDelegate(this)) {
            this.getMultiBlock().writeToNBT(tagCompound);
        }
        return tagCompound;
    }

    @Override
    public void func_145839_a(final NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.multiBlockData.readFromNBT(tagCompound);
        ElecCore.tickHandler.registerCall(new Runnable(){

            @Override
            public void run() {
                if (AbstractMultiBlockTile.this.getMultiBlock() != null && AbstractMultiBlockTile.this.getMultiBlock().isSaveDelegate(AbstractMultiBlockTile.this)) {
                    AbstractMultiBlockTile.this.getMultiBlock().readFromNBT(tagCompound);
                }
            }
        }, FMLCommonHandler.instance().getEffectiveSide());
    }

    @Override
    public void setMultiBlock(IMultiBlock multiBlock, EnumFacing facing, String structure) {
        this.multiBlockData.setMultiBlock(multiBlock, facing, structure);
        this.onMultiBlockCreated();
    }

    @Override
    public void invalidateMultiBlock() {
        this.multiBlockData.invalidateMultiBlock();
        this.onMultiBlockRemoved();
    }

    @Override
    public boolean isValidMultiBlock() {
        return this.multiBlockData.isValidMultiBlock();
    }

    @Override
    public String getStructureIdentifier() {
        return this.multiBlockData.getStructureIdentifier();
    }

    @Override
    public EnumFacing getMultiBlockFacing() {
        return this.multiBlockData.getFacing();
    }

    @Override
    public AbstractMultiBlock getMultiBlock() {
        return (AbstractMultiBlock)this.multiBlockData.getMultiBlock();
    }

    protected void onMultiBlockCreated() {
    }

    protected void onMultiBlockRemoved() {
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.multiBlockData.tileEntityValidate();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.multiBlockData.tileEntityChunkUnload();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.multiBlockData.tileEntityInvalidate();
    }

    @Override
    public Container getGuiServer(EntityPlayer player) {
        return this.getMultiBlock() == null ? null : this.getMultiBlock().getGuiServer(player);
    }

    @Override
    public Object getGuiClient(EntityPlayer player) {
        return this.getMultiBlock() == null ? null : this.getMultiBlock().getGuiClient(player);
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (this.getMultiBlock() != null) {
            return this.getMultiBlock().getWailaBody(itemStack, currentTip, accessor, config);
        }
        return currentTip;
    }

    @Override
    public NBTTagCompound getWailaTag(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (this.getMultiBlock() != null) {
            return this.getMultiBlock().getWailaTag(player, te, tag, world, pos);
        }
        return tag;
    }

    public final boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        boolean hasMB = this.getMultiBlock() != null;
        return this.hasCapability(capability, facing, hasMB);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing, boolean hasMultiBlock) {
        return this.canFetchNonMultiBlockCapabilities(hasMultiBlock) && this.hasBaseCapability(capability, facing) || this.hasMultiBlockCapability(capability, facing);
    }

    public final boolean hasMultiBlockCapability(Capability<?> capability, EnumFacing facing) {
        return this.getMultiBlock() != null && this.getMultiBlock().hasCapability(capability, facing, this.func_174877_v());
    }

    protected final boolean hasBaseCapability(Capability<?> capability, EnumFacing facing) {
        return super.hasCapability(capability, facing);
    }

    public final <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        boolean hasMB = this.getMultiBlock() != null;
        return this.getCapability(capability, facing, hasMB);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing, boolean hasMultiBlock) {
        T t;
        T t2 = t = !this.canFetchNonMultiBlockCapabilities(hasMultiBlock) ? null : (T)this.getBaseCapability(capability, facing);
        if (t == null) {
            return this.getMultiBlockCapability(capability, facing);
        }
        return t;
    }

    public final <T> T getMultiBlockCapability(Capability<T> capability, EnumFacing facing) {
        return this.getMultiBlock() == null ? null : (T)this.getMultiBlock().getCapability(capability, facing, this.func_174877_v());
    }

    protected final <T> T getBaseCapability(Capability<T> capability, EnumFacing facing) {
        return (T)super.getCapability(capability, facing);
    }

    protected boolean canFetchNonMultiBlockCapabilities(boolean hasMultiBlock) {
        return true;
    }
}

