/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.multiblock;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import elec332.core.client.RenderHelper;
import elec332.core.multiblock.IMultiBlock;
import elec332.core.multiblock.IMultiBlockRenderer;
import elec332.core.multiblock.IMultiBlockStructure;
import elec332.core.multiblock.IMultiBlockTile;
import elec332.core.multiblock.MultiBlockStructureRegistry;
import elec332.core.network.NetworkHandler;
import elec332.core.registry.AbstractWorldRegistryHolder;
import elec332.core.registry.IWorldRegistry;
import elec332.core.world.WorldHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class MultiBlockRegistry
extends AbstractWorldRegistryHolder<MultiBlockWorldRegistry> {
    private Map<Class<? extends IMultiBlockStructure>, Class<? extends IMultiBlock>> registry = Maps.newHashMap();
    private Map<Class<? extends IMultiBlock>, IMultiBlockRenderer<? extends IMultiBlock>> multiBlockRendererMap = Maps.newHashMap();
    private final MultiBlockStructureRegistry structureRegistry;
    protected final NetworkHandler networkHandler;

    public MultiBlockRegistry() {
        this(new NetworkHandler(Loader.instance().activeModContainer().getModId() + "|MultiBlocks"));
    }

    public MultiBlockRegistry(NetworkHandler networkHandler) {
        this.networkHandler = networkHandler;
        this.structureRegistry = new MultiBlockStructureRegistry(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean serverOnly() {
        return false;
    }

    @Override
    public MultiBlockWorldRegistry newRegistry(World world) {
        return new MultiBlockWorldRegistry(world);
    }

    public void registerMultiBlock(IMultiBlockStructure multiBlockStructure, String name, Class<? extends IMultiBlock> multiBlock) {
        this.registry.put(multiBlockStructure.getClass(), multiBlock);
        this.structureRegistry.registerMultiBlockStructure(multiBlockStructure, name);
    }

    public <M extends IMultiBlock> void registerMultiBlockRenderer(Class<M> clazz, IMultiBlockRenderer<M> renderer) {
        this.multiBlockRendererMap.put(clazz, renderer);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderMultiBlocks(RenderWorldLastEvent event) {
        MultiBlockWorldRegistry mbwr = (MultiBlockWorldRegistry)this.get((World)Minecraft.func_71410_x().field_71441_e, false);
        if (mbwr != null) {
            ICamera camera = RenderHelper.getPlayerCamera(event.getPartialTicks());
            for (IMultiBlock multiBlock : mbwr.activeMultiBlocks) {
                IMultiBlockRenderer<? extends IMultiBlock> mbr = this.multiBlockRendererMap.get(multiBlock.getClass());
                if (mbr == null || !camera.func_78546_a(mbr.getRenderingBoundingBox(multiBlock))) continue;
                GlStateManager.func_179094_E();
                RenderHelper.translateToWorld(event.getPartialTicks());
                mbr.renderMultiBlock(multiBlock, event.getPartialTicks());
                GlStateManager.func_179121_F();
            }
        }
    }

    public MultiBlockStructureRegistry getStructureRegistry() {
        return this.structureRegistry;
    }

    public class MultiBlockWorldRegistry
    implements IWorldRegistry {
        private final World world;
        private List<IMultiBlock> activeMultiBlocks;
        private List<IMultiBlock> pausedMultiBlocks;

        protected MultiBlockWorldRegistry(World world) {
            this.world = world;
            this.activeMultiBlocks = Lists.newArrayList();
            this.pausedMultiBlocks = Lists.newArrayList();
        }

        protected World getWorldObj() {
            return this.world;
        }

        protected void invalidateMultiBlock(IMultiBlock multiBlock) {
            for (BlockPos loc : multiBlock.getAllMultiBlockLocations()) {
                TileEntity tile = WorldHelper.getTileAt((IBlockAccess)this.world, loc);
                if (!(tile instanceof IMultiBlockTile)) continue;
                ((IMultiBlockTile)tile).invalidateMultiBlock();
            }
            this.activeMultiBlocks.remove(multiBlock);
            multiBlock.invalidate();
        }

        protected void deactivateMultiBlock(IMultiBlock multiBlock) {
            this.activeMultiBlocks.remove(multiBlock);
            this.pausedMultiBlocks.add(multiBlock);
        }

        protected void reactivateMultiBlock(IMultiBlock multiBlock) {
            this.pausedMultiBlocks.remove(multiBlock);
            this.activeMultiBlocks.add(multiBlock);
        }

        protected void createNewMultiBlock(IMultiBlockStructure multiBlockStructure, BlockPos bottomLeft, List<BlockPos> allLocations, World world, EnumFacing facing) {
            IMultiBlock multiBlock;
            Class clazz = (Class)MultiBlockRegistry.this.registry.get(multiBlockStructure.getClass());
            try {
                multiBlock = (IMultiBlock)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking class: " + clazz.getName() + " Please make sure the constructor has no arguments!", e);
            }
            multiBlock.initMain(bottomLeft, facing, allLocations, this, MultiBlockRegistry.this.structureRegistry.getIdentifier(multiBlockStructure));
            boolean one = false;
            for (BlockPos loc : allLocations) {
                TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, loc);
                if (!(tile instanceof IMultiBlockTile)) continue;
                ((IMultiBlockTile)tile).setMultiBlock(multiBlock, facing, MultiBlockRegistry.this.structureRegistry.getIdentifier(multiBlockStructure));
                one = true;
            }
            if (!one) {
                throw new IllegalArgumentException("A multiblock must contain at LEAST 1 IMultiBlockTile");
            }
            this.activeMultiBlocks.add(multiBlock);
        }

        @Override
        public void tick() {
            for (IMultiBlock multiBlock : new Iterable<IMultiBlock>(){

                @Override
                public Iterator<IMultiBlock> iterator() {
                    return MultiBlockWorldRegistry.this.activeMultiBlocks.listIterator();
                }
            }) {
                multiBlock.onTick();
            }
        }

        @Override
        public void onWorldUnload() {
        }
    }
}

