/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.multiblock;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import elec332.core.main.ElecCore;
import elec332.core.multiblock.AbstractAdvancedMultiBlockStructure;
import elec332.core.multiblock.BlockStructure;
import elec332.core.multiblock.IMultiBlockStructure;
import elec332.core.multiblock.IMultiBlockTile;
import elec332.core.multiblock.MultiBlockRegistry;
import elec332.core.network.AbstractMessage;
import elec332.core.server.ServerHelper;
import elec332.core.util.EnumHelper;
import elec332.core.util.NBTHelper;
import elec332.core.world.WorldHelper;
import elec332.core.world.location.BlockStateWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class MultiBlockStructureRegistry
implements IMessageHandler<SyncMultiBlockPacket, IMessage> {
    private final MultiBlockRegistry multiBlockRegistry;
    private Map<String, IMultiBlockStructure> multiBlockStructures = Maps.newHashMap();

    protected MultiBlockStructureRegistry(MultiBlockRegistry multiBlockRegistry) {
        this.multiBlockRegistry = multiBlockRegistry;
        multiBlockRegistry.networkHandler.getNetworkWrapper().registerMessage((IMessageHandler)this, SyncMultiBlockPacket.class, 0, Side.CLIENT);
    }

    protected void registerMultiBlockStructure(IMultiBlockStructure multiBlock, String name) {
        this.multiBlockStructures.put(name, multiBlock);
    }

    protected String getIdentifier(IMultiBlockStructure structure) {
        for (Map.Entry<String, IMultiBlockStructure> entry : this.multiBlockStructures.entrySet()) {
            if (!entry.getValue().equals(structure)) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("ERROR: Structure: " + structure.getClass().getName() + " is not registered!");
    }

    public boolean attemptCreate(EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        if (world.field_72995_K) {
            return false;
        }
        BlockStateWrapper blockData = this.atLocation((IBlockAccess)world, pos);
        if (blockData == null) {
            return false;
        }
        for (IMultiBlockStructure multiBlock : this.multiBlockStructures.values()) {
            if (!multiBlock.getTriggerBlock().equals(blockData) || multiBlock instanceof AbstractAdvancedMultiBlockStructure && !((AbstractAdvancedMultiBlockStructure)multiBlock).canCreate((EntityPlayerMP)player) || !this.tryCreateStructure(multiBlock, world, pos, side, false)) continue;
            return true;
        }
        return false;
    }

    protected boolean attemptReCreate(String s, TileEntity tile, EnumFacing facing) {
        return this.tryCreateStructure(this.multiBlockStructures.get(s), tile.func_145831_w(), tile.func_174877_v(), facing, true);
    }

    private boolean tryCreateStructure(IMultiBlockStructure multiBlock, World world, BlockPos pos, EnumFacing side, boolean recreate) {
        if (side == null || side == EnumFacing.UP || side == EnumFacing.DOWN) {
            return false;
        }
        BlockStateWrapper leftBottomCorner = null;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int newX = x;
        int newY = y;
        int newZ = z;
        block0: for (int i = 0; i < multiBlock.getStructure().getHn() + 1; ++i) {
            BlockStateWrapper temp1;
            if (side == EnumFacing.NORTH || side == EnumFacing.EAST) {
                temp1 = this.atLocation((IBlockAccess)world, newX + 1, y, z);
                if (temp1 != null && multiBlock.getStructure().getBlockTypes().contains(temp1)) {
                    ++newX;
                    continue;
                }
            } else if ((side == EnumFacing.SOUTH || side == EnumFacing.WEST) && (temp1 = this.atLocation((IBlockAccess)world, newX - 1, y, z)) != null && multiBlock.getStructure().getBlockTypes().contains(temp1)) {
                --newX;
                continue;
            }
            for (int j = 0; j < multiBlock.getStructure().getHn() + 1; ++j) {
                if ((temp1 = this.atLocation((IBlockAccess)world, newX, --newY, z)) != null && multiBlock.getStructure().getBlockTypes().contains(temp1)) continue;
                ++newY;
                for (int k = 0; k < multiBlock.getStructure().getHn() + 1; ++k) {
                    if (side == EnumFacing.NORTH || side == EnumFacing.WEST) {
                        temp1 = this.atLocation((IBlockAccess)world, newX, newY, newZ - 1);
                        if (temp1 != null && multiBlock.getStructure().getBlockTypes().contains(temp1)) {
                            --newZ;
                            continue;
                        }
                    } else if ((side == EnumFacing.EAST || side == EnumFacing.SOUTH) && (temp1 = this.atLocation((IBlockAccess)world, newX, newY, newZ + 1)) != null && multiBlock.getStructure().getBlockTypes().contains(temp1)) {
                        ++newZ;
                        continue;
                    }
                    leftBottomCorner = this.atLocation((IBlockAccess)world, newX, newY, newZ);
                    break block0;
                }
            }
        }
        if (leftBottomCorner != null && this.areBlocksAtRightPlace(multiBlock.getStructure(), world, newX, newY, newZ, side)) {
            if (multiBlock instanceof AbstractAdvancedMultiBlockStructure && !((AbstractAdvancedMultiBlockStructure)multiBlock).areSecondaryConditionsMet(world, new BlockPos(newX, newY, newZ), side)) {
                return false;
            }
            if (multiBlock.replaceUponCreated() != null) {
                BlockStructure main = multiBlock.getStructure();
                this.replaceAll(main, world, newX, newY, newZ, side, main.newBlockStructureWithSameDimensions(multiBlock.replaceUponCreated()));
            }
            ((MultiBlockRegistry.MultiBlockWorldRegistry)this.multiBlockRegistry.get(world)).createNewMultiBlock(multiBlock, new BlockPos(newX, newY, newZ), this.getAllMultiBlockLocations(multiBlock.getStructure(), newX, newY, newZ, side), world, side);
            if (!recreate && !world.field_72995_K) {
                for (EntityPlayerMP player : ServerHelper.instance.getAllPlayersWatchingBlock(world, newX, newZ)) {
                    this.multiBlockRegistry.networkHandler.getNetworkWrapper().sendTo((IMessage)new SyncMultiBlockPacket(multiBlock, x, y, z, side, this), player);
                }
            }
            int hn = multiBlock.getStructure().getHn();
            world.func_147458_c(newX, newY, newZ, newX + hn, newY + hn, newZ + hn);
            return true;
        }
        return false;
    }

    private List<BlockPos> getAllMultiBlockLocations(BlockStructure multiBlock, final int x, final int y, final int z, final EnumFacing side) {
        final ArrayList ret = Lists.newArrayList();
        multiBlock.startLoop(new BlockStructure.IPositionCall(){

            @Override
            public void forPos(int length, int width, int height) {
                ret.add(MultiBlockStructureRegistry.getTranslated(x, y, z, side, length, width, height));
            }
        });
        return ret;
    }

    private void replaceAll(BlockStructure multiBlock, World world, int x, int y, int z, EnumFacing side, BlockStructure toReplace) {
        this.replaceAll(multiBlock, world, new BlockPos(x, y, z), side, toReplace);
    }

    private void replaceAll(BlockStructure multiBlock, final World world, final BlockPos pos, final EnumFacing side, final BlockStructure toReplace) {
        multiBlock.startLoop(new BlockStructure.IPositionCall(){

            @Override
            public void forPos(int length, int width, int height) {
                BlockPos loc = MultiBlockStructureRegistry.getTranslated(pos, side, length, width, height);
                BlockStateWrapper data = toReplace.getStructure()[length][width][height];
                world.func_175698_g(loc);
                world.func_180501_a(loc, data.getBlockState(), 3);
            }
        });
    }

    private boolean areBlocksAtRightPlace(final BlockStructure multiBlock, final World world, final int x, final int y, final int z, final EnumFacing side) {
        try {
            multiBlock.startLoop(new BlockStructure.IPositionCall(){

                @Override
                public void forPos(int length, int width, int height) {
                    BlockPos translated = MultiBlockStructureRegistry.getTranslated(x, y, z, side, length, width, height);
                    BlockStateWrapper bsw = multiBlock.getStructure()[length][width][height];
                    if (bsw != null && !bsw.equals(MultiBlockStructureRegistry.this.atLocation((IBlockAccess)world, translated)) || MultiBlockStructureRegistry.this.hasMultiBlock(translated, world)) {
                        System.out.println("Checking MB failed at relative: " + length + ", " + width + ", " + height);
                        System.out.println("Found: " + MultiBlockStructureRegistry.this.atLocation((IBlockAccess)world, translated) + ", expected: " + multiBlock.getStructure()[length][width][height]);
                        throw new RuntimeException("INVALID");
                    }
                }
            });
        }
        catch (RuntimeException e) {
            System.out.println("INVALID");
            if (e.getMessage() != null && e.getMessage().equals("INVALID")) {
                return false;
            }
            throw new RuntimeException(e);
        }
        System.out.println("VALID STUFF HERE, YAYZZZ :D");
        return true;
    }

    private boolean hasMultiBlock(BlockPos loc, World world) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, loc);
        return tile instanceof IMultiBlockTile && ((IMultiBlockTile)tile).getMultiBlock() != null;
    }

    protected static BlockPos getTranslated(BlockPos pos, EnumFacing side, int length, int width, int height) {
        return MultiBlockStructureRegistry.getTranslated(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), side, length, width, height);
    }

    protected static BlockPos getTranslated(int x, int y, int z, EnumFacing side, int length, int width, int height) {
        int newZ;
        int newX;
        if (side == EnumFacing.NORTH) {
            newX = x - length;
            newZ = z + width;
        } else if (side == EnumFacing.EAST) {
            newX = x - width;
            newZ = z - length;
        } else if (side == EnumFacing.SOUTH) {
            newX = x + length;
            newZ = z - width;
        } else if (side == EnumFacing.WEST) {
            newX = x + width;
            newZ = z + length;
        } else {
            throw new IllegalArgumentException("Cannot process side: " + side);
        }
        int newY = y + height;
        return new BlockPos(newX, newY, newZ);
    }

    private BlockStateWrapper atLocation(IBlockAccess world, int x, int y, int z) {
        return this.atLocation(world, new BlockPos(x, y, z));
    }

    private BlockStateWrapper atLocation(IBlockAccess world, BlockPos pos) {
        Block block = WorldHelper.getBlockAt(world, pos);
        int meta = WorldHelper.getBlockMeta(world, pos);
        if (block == null || block == Blocks.field_150350_a) {
            return new BlockStateWrapper((Block)null);
        }
        return new BlockStateWrapper(block, meta);
    }

    public IMessage onMessage(final SyncMultiBlockPacket message, MessageContext ctx) {
        ElecCore.tickHandler.registerCall(new Runnable(){

            @Override
            public void run() {
                NBTTagCompound tag = message.networkPackageObject;
                MultiBlockStructureRegistry.this.tryCreateStructure((IMultiBlockStructure)MultiBlockStructureRegistry.this.multiBlockStructures.get(tag.func_74779_i("mbs")), MultiBlockStructureRegistry.this.getClientWorld(), new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z")), EnumHelper.fromString(tag.func_74779_i("side"), EnumFacing.class), false);
            }
        }, ctx.side);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static final class SyncMultiBlockPacket
    extends AbstractMessage {
        public SyncMultiBlockPacket() {
            super(null);
        }

        private SyncMultiBlockPacket(IMultiBlockStructure multiBlock, int x, int y, int z, EnumFacing side, MultiBlockStructureRegistry structureRegistry) {
            super(new NBTHelper().addToTag(x, "x").addToTag(y, "y").addToTag(z, "z").addToTag((Enum)side, "side").addToTag(structureRegistry.getIdentifier(multiBlock), "mbs").serializeNBT());
        }
    }
}

