/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.nbt;

import com.google.common.base.Function;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public class NBTMap<K, V>
extends HashMap<K, V>
implements INBTSerializable<NBTTagList> {
    private final Class<K> kClass;
    private final Class<V> vClass;
    private final boolean kNBT;
    private final boolean vNBT;
    private final Callable<K> kCallable;
    private final Function<K, V> vCallable;

    public static <K extends INBTSerializable, V extends INBTSerializable> NBTMap<K, V> newNBTMap(@Nonnull Class<K> kClazz, @Nonnull Callable<K> kCallable, @Nonnull Class<V> vClazz, @Nonnull Function<K, V> vCallable) {
        return NBTMap.newNBTMap_(kClazz, kCallable, vClazz, vCallable);
    }

    public static <K, V extends INBTSerializable> NBTMap<K, V> newNBTMap(@Nonnull Class<K> kClazz, @Nonnull Class<V> vClazz, @Nonnull Function<K, V> vCallable) {
        return NBTMap.newNBTMap_(kClazz, null, vClazz, vCallable);
    }

    public static <K extends INBTSerializable, V> NBTMap<K, V> newNBTMap(@Nonnull Class<K> kClazz, @Nonnull Callable<K> kCallable, @Nonnull Class<V> vClazz) {
        return NBTMap.newNBTMap_(kClazz, kCallable, vClazz, null);
    }

    public static <K, V> NBTMap<K, V> newNBTMap(@Nonnull Class<K> kClazz, @Nonnull Class<V> vClazz) {
        return NBTMap.newNBTMap_(kClazz, null, vClazz, null);
    }

    private static <K, V> NBTMap<K, V> newNBTMap_(@Nonnull Class<K> kClazz, Callable<K> kCallable, @Nonnull Class<V> vClazz, Function<K, V> vCallable) {
        boolean b;
        if (!NBTMap.isValidNBT(kClazz) && ((b = INBTSerializable.class.isAssignableFrom(kClazz)) && kCallable == null || !b) && !NBTBase.class.isAssignableFrom(kClazz)) {
            throw new IllegalArgumentException();
        }
        if (!NBTMap.isValidNBT(vClazz) && ((b = INBTSerializable.class.isAssignableFrom(vClazz)) && vCallable == null || !b) && !NBTBase.class.isAssignableFrom(vClazz)) {
            throw new IllegalArgumentException();
        }
        return new NBTMap<K, V>(kClazz, kCallable, vClazz, vCallable);
    }

    private NBTMap(Class<K> kClazz, Callable<K> kCallable, Class<V> vClass, Function<K, V> vCallable) {
        this.kClass = kClazz;
        this.vClass = vClass;
        this.kNBT = kCallable != null;
        this.vNBT = vCallable != null;
        this.kCallable = kCallable;
        this.vCallable = vCallable;
    }

    public NBTTagList serializeNBT() {
        NBTTagList ret = new NBTTagList();
        for (Map.Entry entry : this.entrySet()) {
            if (entry.getValue() == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            this.writeToNBT(tag, "k", entry.getKey());
            this.writeToNBT(tag, "v", entry.getValue());
            ret.func_74742_a((NBTBase)tag);
        }
        return ret;
    }

    @Override
    public V put(K key, V value) {
        return super.put(key, value);
    }

    public void deserializeNBT(NBTTagList nbt) {
        try {
            this.clear();
            for (int i = 0; i < nbt.func_74745_c(); ++i) {
                Object v;
                K k;
                NBTTagCompound tag = nbt.func_150305_b(i);
                if (this.kNBT) {
                    k = this.kCallable.call();
                    ((INBTSerializable)k).deserializeNBT(tag.func_74781_a("k"));
                } else {
                    k = this.readFromNBT(tag, "k", this.kClass);
                }
                if (k instanceof Nullifyable && ((Nullifyable)k).shouldNullify()) continue;
                if (this.vNBT) {
                    v = this.vCallable.apply(k);
                    ((INBTSerializable)v).deserializeNBT(tag.func_74781_a("v"));
                } else {
                    v = this.readFromNBT(tag, "v", this.vClass);
                }
                if (v instanceof Nullifyable && ((Nullifyable)v).shouldNullify()) continue;
                this.put(k, v);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeToNBT(NBTTagCompound tag, String name, Object toWrite) {
        NBTBase serialized;
        if (toWrite == null) {
            throw new NullPointerException();
        }
        if (toWrite instanceof NBTBase) {
            serialized = (NBTBase)toWrite;
        } else if (toWrite instanceof INBTSerializable) {
            serialized = ((INBTSerializable)toWrite).serializeNBT();
        } else if (toWrite instanceof String) {
            serialized = new NBTTagString((String)toWrite);
        } else if (toWrite instanceof UUID) {
            serialized = new NBTTagString(toWrite.toString());
        } else if (toWrite.getClass().equals(Byte.class)) {
            serialized = new NBTTagByte(((Byte)toWrite).byteValue());
        } else if (toWrite.getClass().equals(Short.class)) {
            serialized = new NBTTagShort(((Short)toWrite).shortValue());
        } else if (toWrite.getClass().equals(Integer.class)) {
            serialized = new NBTTagInt(((Integer)toWrite).intValue());
        } else if (ResourceLocation.class.isInstance(toWrite)) {
            serialized = new NBTTagString(toWrite.toString());
        } else {
            throw new IllegalArgumentException();
        }
        if (serialized == null) {
            throw new IllegalArgumentException();
        }
        tag.func_74782_a(name, serialized);
    }

    private <T> T readFromNBT(NBTTagCompound tag, String name, Class<T> type) {
        NBTBase data = tag.func_74781_a(name);
        if (data == null) {
            return null;
        }
        if (NBTBase.class.isAssignableFrom(type)) {
            return (T)data;
        }
        if (type == String.class) {
            return (T)((NBTTagString)data).func_150285_a_();
        }
        if (type == UUID.class) {
            return (T)UUID.fromString(((NBTTagString)data).func_150285_a_());
        }
        if (type.equals(Byte.class)) {
            return (T)Byte.valueOf(((NBTBase.NBTPrimitive)data).func_150290_f());
        }
        if (type.equals(Short.class)) {
            return (T)Short.valueOf(((NBTBase.NBTPrimitive)data).func_150289_e());
        }
        if (type.equals(Integer.class)) {
            return (T)Integer.valueOf(((NBTBase.NBTPrimitive)data).func_150287_d());
        }
        if (ResourceLocation.class.isAssignableFrom(type)) {
            return (T)new ResourceLocation(((NBTTagString)data).func_150285_a_());
        }
        throw new IllegalArgumentException();
    }

    private static boolean isValidNBT(Class clazz) {
        return clazz == String.class || clazz == UUID.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || ResourceLocation.class.isAssignableFrom(clazz);
    }

    public static interface Nullifyable {
        default public boolean shouldNullify() {
            return false;
        }
    }
}

