/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.network;

import elec332.core.network.AbstractPacket;
import elec332.core.util.NBTHelper;
import elec332.core.world.WorldHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractPacketTileAction
extends AbstractPacket {
    public AbstractPacketTileAction() {
    }

    public AbstractPacketTileAction(TileEntity tile, NBTTagCompound message) {
        this(tile, message, 0);
    }

    public AbstractPacketTileAction(TileEntity tile, NBTTagCompound message, int id) {
        super(new NBTHelper().addToTag((NBTBase)message, "data").addToTag(id, "id").addToTag(tile.func_174877_v()).serializeNBT());
    }

    @Override
    public IMessage onMessageThreadSafe(AbstractPacket message, MessageContext ctx) {
        NBTHelper tag = new NBTHelper(message.networkPackageObject);
        BlockPos loc = tag.getPos();
        int i = tag.getInteger("id");
        NBTTagCompound data = tag.getCompoundTag("data");
        if (ctx.side == Side.CLIENT) {
            return this.processClient(loc, i, data, ctx);
        }
        this.processPacket(WorldHelper.getTileAt((IBlockAccess)ctx.getServerHandler().field_147369_b.field_70170_p, loc), i, data, ctx);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private IMessage processClient(BlockPos loc, int id, NBTTagCompound data, MessageContext ctx) {
        this.processPacket(WorldHelper.getTileAt((IBlockAccess)Minecraft.func_71410_x().field_71441_e, loc), id, data, ctx);
        return null;
    }

    public abstract void processPacket(TileEntity var1, int var2, NBTTagCompound var3, MessageContext var4);
}

