/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.proxies;

import elec332.core.client.model.EventHandler;
import elec332.core.client.model.IElecResourceManager;
import elec332.core.client.newstuff.ElecModelHandler;
import elec332.core.item.IColoredItem;
import elec332.core.main.ElecCore;
import elec332.core.proxies.CommonProxy;
import elec332.core.util.RegistryHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private static final IItemColor COLORED_ITEM = new IItemColor(){

        public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
            return ((IColoredItem)stack.func_77973_b()).getColorFromItemStack(stack, tintIndex);
        }
    };
    private static final IItemColor COLORED_ITEMBLOCK = new IItemColor(){

        public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
            return ((IColoredItem)stack.func_77973_b()).getColorFromItemStack(stack, tintIndex);
        }
    };
    private static final IBlockColor COLORED_BLOCK = new IBlockColor(){

        public int func_186720_a(@Nonnull IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
            return 0;
        }
    };
    private boolean registered;

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void preInitRendering() {
        IResourceManager resourceManager = this.minecraft.func_110442_L();
        if (!(resourceManager instanceof SimpleReloadableResourceManager)) {
            ElecCore.logger.error("Someone replaced the resource manager, but it doesn't extend SimpleResourceManager!");
            ElecCore.logger.error("This is an severe error, forge will crash further down the line, exiting minecraft now!");
            ElecCore.logger.error("Source: " + resourceManager.getClass().getCanonicalName());
            throw new RuntimeException("Class: " + resourceManager.getClass().getCanonicalName() + " is not a valid replacement for the vanilla resource manager.");
        }
        ((SimpleReloadableResourceManager)resourceManager).func_110542_a((IResourceManagerReloadListener)new ModelReloadListener());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    @Override
    public void postInitRendering() {
        for (Item item : RegistryHelper.getItemRegistry()) {
            if (!(item instanceof IColoredItem)) continue;
            this.minecraft.field_184128_aI.func_186730_a(COLORED_ITEM, new Item[]{item});
        }
    }

    @Override
    public void addPersonalMessageToPlayer(String s) {
        this.minecraft.field_71439_g.func_146105_b((ITextComponent)new TextComponentString(s));
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    private class ModelReloadListener
    implements IResourceManagerReloadListener {
        private ModelReloadListener() {
        }

        public void func_110549_a(@Nonnull IResourceManager resourceManager) {
            if (((ClientProxy)ClientProxy.this).minecraft.field_175621_X != null) {
                ElecModelHandler.registerBlockModels(((ClientProxy)ClientProxy.this).minecraft.field_175617_aL);
                ElecModelHandler.registerItemModels(((ClientProxy)ClientProxy.this).minecraft.field_175621_X);
                ElecModelHandler.registerMultiPartModels();
            }
        }
    }

    private class RenderReplacer
    implements IElecResourceManager.IResourceHook {
        private RenderReplacer() {
        }

        @Override
        public boolean onRegister(IReloadableResourceManager resourceManager, IResourceManagerReloadListener listener) {
            if (listener instanceof ModelManager && !ClientProxy.this.registered) {
                resourceManager.func_110542_a((IResourceManagerReloadListener)new ModelReloadListener());
                ClientProxy.this.registered = true;
            }
            return true;
        }
    }
}

