/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.server;

import com.google.common.collect.Lists;
import elec332.core.api.annotations.ASMDataProcessor;
import elec332.core.api.util.IASMDataHelper;
import elec332.core.api.util.IASMDataProcessor;
import elec332.core.main.ElecCore;
import elec332.core.server.ExternalSaveHandler;
import elec332.core.server.IExternalSaveHandler;
import elec332.core.server.ServerHelper;
import elec332.core.world.WorldHelper;
import java.io.File;
import java.util.List;
import java.util.Set;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public enum SaveHandler {
    INSTANCE;

    private final List<IExternalSaveHandler> saveHandlers = Lists.newArrayList();

    public void dummyLoad() {
    }

    private void load(File worldDir) {
        for (IExternalSaveHandler saveHandler : this.saveHandlers) {
            saveHandler.load(worldDir);
        }
    }

    private void save(File worldDir) {
        for (IExternalSaveHandler saveHandler : this.saveHandlers) {
            saveHandler.save(worldDir);
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    @ASMDataProcessor(value={LoaderState.POSTINITIALIZATION})
    public static class ASMLoader
    implements IASMDataProcessor {
        @Override
        public void processASMData(IASMDataHelper asmData, LoaderState state) {
            if (INSTANCE.saveHandlers.isEmpty()) {
                ElecCore.logger.info("Initializing SaveHandlers.");
                Set<ASMDataTable.ASMData> dataSet = asmData.getAnnotationList(ExternalSaveHandler.class);
                for (ASMDataTable.ASMData data : dataSet) {
                    try {
                        Class<?> clazz = this.getClass().getClassLoader().loadClass(data.getClassName());
                        if (!IExternalSaveHandler.class.isAssignableFrom(clazz)) continue;
                        INSTANCE.saveHandlers.add((IExternalSaveHandler)clazz.newInstance());
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            } else {
                throw new IllegalStateException();
            }
            ElecCore.logger.info("Initializing SaveHandlers complete.");
        }
    }

    public static class EventHandler {
        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
            if (ServerHelper.isServer(event.getWorld()) && WorldHelper.getDimID(event.getWorld()) == 0 && event.getWorld().getClass() == WorldServer.class) {
                INSTANCE.load(event.getWorld().func_72860_G().func_75765_b());
            }
        }

        @SubscribeEvent
        public void onWorldSave(WorldEvent.Save event) {
            if (ServerHelper.isServer(event.getWorld()) && WorldHelper.getDimID(event.getWorld()) == 0 && event.getWorld().getClass() == WorldServer.class) {
                INSTANCE.save(event.getWorld().func_72860_G().func_75765_b());
            }
        }
    }
}

