/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.server;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import elec332.core.main.ElecCore;
import elec332.core.nbt.NBTMap;
import elec332.core.network.NetworkHandler;
import elec332.core.server.ElecPlayer;
import elec332.core.server.SaveHandler;
import elec332.core.util.NBTHelper;
import elec332.core.util.PlayerHelper;
import elec332.core.world.WorldHelper;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.io.FileUtils;
import scala.collection.generic.Clearable;

public class ServerHelper {
    public static final ServerHelper instance = new ServerHelper();
    private final Map<String, Class<? extends ElecPlayer.ExtendedProperties>> extendedPropertiesList_;
    private final Map<String, Callable<INBTSerializable>> extendedSaveData_;
    private final Map<String, Class<? extends ElecPlayer.ExtendedProperties>> extendedPropertiesList;
    private final Map<String, Callable<INBTSerializable>> extendedSaveData;
    private NBTHelper generalData;
    private NBTMap<UUID, ElecPlayer> playerData;
    private NBTMap<Integer, NBTHelper> worldData;
    private NBTMap<String, INBTSerializable> savedData;
    private boolean locked;
    private boolean loaded;

    private ServerHelper() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        this.playerData = NBTMap.newNBTMap(UUID.class, ElecPlayer.class, new Function<UUID, ElecPlayer>(){

            public ElecPlayer apply(UUID input) {
                ElecPlayer ret = new ElecPlayer(input);
                ret.setExtendedProperties(ServerHelper.this.extendedPropertiesList);
                return ret;
            }
        });
        this.worldData = NBTMap.newNBTMap(Integer.class, NBTHelper.class, new NBTHelper.DefaultFunction());
        this.savedData = NBTMap.newNBTMap(String.class, INBTSerializable.class, new Function<String, INBTSerializable>(){

            @Nullable
            public INBTSerializable apply(@Nullable String input) {
                try {
                    return (INBTSerializable)((Callable)ServerHelper.this.extendedSaveData.get(input)).call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.extendedPropertiesList_ = Maps.newHashMap();
        this.extendedPropertiesList = Collections.unmodifiableMap(this.extendedPropertiesList_);
        this.extendedSaveData_ = Maps.newHashMap();
        this.extendedSaveData = Collections.unmodifiableMap(this.extendedSaveData_);
        this.locked = false;
        this.setInvalid();
    }

    public void load() {
        SaveHandler.INSTANCE.dummyLoad();
    }

    public void registerExtendedPlayerProperties(String identifier, Class<? extends ElecPlayer.ExtendedProperties> propClass) {
        if (this.extendedPropertiesList_.keySet().contains(identifier)) {
            throw new IllegalArgumentException("Property for " + identifier + " has already been registered!");
        }
        if (Loader.instance().hasReachedState(LoaderState.AVAILABLE) || this.locked) {
            throw new IllegalArgumentException("Mod is attempting to register properties too late: " + identifier + "  " + propClass.getName());
        }
        this.extendedPropertiesList_.put(identifier, propClass);
    }

    public void registerExtendedProperties(String s, Callable<INBTSerializable> callable) {
        if (this.extendedSaveData_.containsKey(s)) {
            throw new IllegalArgumentException("Property for " + s + " has already been registered!");
        }
        if (Loader.instance().hasReachedState(LoaderState.AVAILABLE) || this.locked) {
            throw new IllegalArgumentException("Mod is attempting to register properties too late: " + s + "  " + callable.getClass());
        }
        this.extendedSaveData_.put(s, callable);
    }

    public ElecPlayer getPlayer(EntityPlayer player) {
        return this.getPlayer(PlayerHelper.getPlayerUUID(player));
    }

    public ElecPlayer getPlayer(@Nonnull UUID uuid) {
        if (this.isValid()) {
            return (ElecPlayer)this.playerData.get(uuid);
        }
        return null;
    }

    public NBTHelper getPersistentWorldData(World world) {
        return this.getPersistentWorldData(WorldHelper.getDimID(world));
    }

    public NBTHelper getPersistentWorldData(int i) {
        if (!this.isValid()) {
            return null;
        }
        NBTHelper ret = (NBTHelper)this.worldData.get(i);
        if (ret == null) {
            ret = new NBTHelper(new NBTTagCompound());
            this.worldData.put(i, ret);
        }
        return ret;
    }

    public NBTHelper getPersistentGlobalData() {
        if (this.isValid()) {
            return this.generalData;
        }
        return null;
    }

    public <T extends INBTSerializable<NBTTagCompound>> T getExtendedSaveData(Class<T> clazz, String name) {
        return (T)((INBTSerializable)clazz.cast(this.getExtendedSaveData(name)));
    }

    public INBTSerializable getExtendedSaveData(String name) {
        return (INBTSerializable)this.savedData.get(name);
    }

    public List<EntityPlayerMP> getOnlinePlayers() {
        return this.getMinecraftServer().func_184103_al().func_181057_v();
    }

    public boolean isPlayerOnline(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        ElecPlayer player = this.getPlayer(uuid);
        return player != null && this.getPlayer(uuid).isOnline();
    }

    public EntityPlayerMP getRealPlayer(UUID uuid) {
        if (this.isPlayerOnline(uuid)) {
            for (EntityPlayerMP player : this.getOnlinePlayers()) {
                if (!PlayerHelper.getPlayerUUID((EntityPlayer)player).equals(uuid)) continue;
                return player;
            }
        }
        return null;
    }

    public List<EntityPlayerMP> getAllPlayersWatchingBlock(World world, BlockPos pos) {
        return this.getAllPlayersWatchingBlock(world, pos.func_177958_n(), pos.func_177952_p());
    }

    public List<EntityPlayerMP> getAllPlayersWatchingBlock(World world, int x, int z) {
        ArrayList ret = Lists.newArrayList();
        if (world instanceof WorldServer) {
            PlayerChunkMap playerManager = ((WorldServer)world).func_184164_w();
            for (EntityPlayerMP player : this.getOnlinePlayers()) {
                Chunk chunk = world.func_72964_e(x >> 4, z >> 4);
                if (!playerManager.func_72694_a(player, chunk.field_76635_g, chunk.field_76647_h)) continue;
                ret.add(player);
            }
        }
        return ret;
    }

    public void sendMessageToAllPlayersWatchingBlock(World world, BlockPos pos, IMessage message, NetworkHandler networkHandler) {
        for (EntityPlayerMP player : this.getAllPlayersWatchingBlock(world, pos)) {
            networkHandler.getNetworkWrapper().sendTo(message, player);
        }
    }

    public List<EntityPlayerMP> getAllPlayersInDimension(int dimension) {
        ArrayList ret = Lists.newArrayList();
        for (EntityPlayerMP player : this.getOnlinePlayers()) {
            if (WorldHelper.getDimID(player.field_70170_p) != dimension) continue;
            ret.add(player);
        }
        return ret;
    }

    public void sendMessageToAllPlayersInDimension(int dimension, IMessage message, NetworkHandler networkHandler) {
        for (EntityPlayerMP playerMP : this.getAllPlayersInDimension(dimension)) {
            networkHandler.getNetworkWrapper().sendTo(message, playerMP);
        }
    }

    public MinecraftServer getMinecraftServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public boolean isValid() {
        boolean ret;
        boolean bl = ret = this.getMinecraftServer() != null;
        if (!ret) {
            ElecCore.logger.error("Someone tried to access the server whilst it was in an invalid state!");
        }
        return ret;
    }

    public static boolean isServer(World world) {
        return !world.field_72995_K;
    }

    private void setInvalid() {
        this.generalData = null;
        this.playerData.clear();
        this.worldData.clear();
    }

    private void investigateErrors(boolean errorBefore) {
        if (errorBefore) {
            ElecCore.logger.error("Starting thorough investigation...");
        }
        boolean error = false;
        for (EntityPlayerMP playerMP : this.getOnlinePlayers()) {
            ElecPlayer elecPlayer;
            if (!this.isValid() || (elecPlayer = this.getPlayer((EntityPlayer)playerMP)) != null) continue;
            if (!errorBefore) {
                this.investigateErrors(true);
                return;
            }
            error = true;
            ElecCore.logger.error("Seems like there is a player online that also never properly connected: " + playerMP.func_145748_c_());
        }
        for (ElecPlayer elecPlayer : this.playerData.values()) {
            EntityPlayerMP online;
            if (!elecPlayer.isOnline() || (online = this.getRealPlayer(elecPlayer.getPlayerUUID())) != null) continue;
            if (!errorBefore) {
                this.investigateErrors(true);
                return;
            }
            error = true;
            ElecCore.logger.error("Seems like the player with UUID: " + elecPlayer.getPlayerUUID() + " never properly disconnected from the server.");
        }
        if (errorBefore) {
            if (!error) {
                ElecCore.logger.error("No additional errors found...");
            }
            ElecCore.logger.error("Finished investigation.");
        }
    }

    @Deprecated
    public static NBTTagCompound fromFile(File file) {
        if (file == null) {
            return null;
        }
        try {
            try {
                if (!file.exists()) {
                    ServerHelper.createFile(file);
                    return new NBTTagCompound();
                }
                return CompressedStreamTools.func_74797_a((File)file);
            }
            catch (EOFException e) {
                ElecCore.logger.error("Error reading NBT files, something weird must have happened when you last shutdown MC, unfortunately, some game data will be lost. Fixing file now....");
                String date = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
                String ext = file.getName().replace('.', ' ').split(" ")[1];
                File newFile = new File(file.getCanonicalPath().replace("." + ext, "-" + date + "." + ext));
                FileUtils.moveFile((File)file, (File)newFile);
                ServerHelper.createFile(file);
                try {
                    File backup = ServerHelper.getBackupFile(file);
                    if (backup.exists()) {
                        return CompressedStreamTools.func_74797_a((File)backup);
                    }
                }
                catch (IOException ex) {
                    ElecCore.logger.info("Failed to read backup file: " + file);
                }
                return new NBTTagCompound();
            }
        }
        catch (IOException e) {
            ElecCore.logger.error("Failed to load " + file, (Throwable)e);
            return new NBTTagCompound();
        }
    }

    @Deprecated
    public static void createFile(File file) throws IOException {
        if (!(file.exists() || file.getParentFile().mkdirs() || file.createNewFile())) {
            throw new IOException();
        }
    }

    @Deprecated
    public void toFile(NBTTagCompound tagCompound, File file) {
        try {
            if (file.exists()) {
                Files.move((File)file, (File)ServerHelper.getBackupFile(file));
            }
            file.createNewFile();
            CompressedStreamTools.func_74795_b((NBTTagCompound)tagCompound, (File)file);
        }
        catch (IOException e) {
            ElecCore.logger.error("Failed to save " + file, (Throwable)e);
        }
    }

    @Deprecated
    private static File getBackupFile(File file) throws IOException {
        return new File(file.getCanonicalPath() + "_back");
    }

    public class EventHandler {
        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
            if (ServerHelper.isServer(event.getWorld()) && WorldHelper.getDimID(event.getWorld()) == 0 && event.getWorld().getClass() == WorldServer.class) {
                if (!ServerHelper.this.locked) {
                    ServerHelper.this.locked = true;
                }
                File folder = new File(event.getWorld().func_72860_G().func_75765_b(), "elec332/");
                ServerHelper.this.generalData = new NBTHelper(ServerHelper.fromFile(new File(folder, "generalData.dat")));
                NBTTagList tagList1 = ServerHelper.fromFile(new File(folder, "playerData.dat")).func_150295_c("playerData", 10);
                ServerHelper.this.playerData.deserializeNBT(tagList1);
                NBTTagList tagList2 = ServerHelper.fromFile(new File(folder, "worldData.dat")).func_150295_c("dimData", 10);
                ServerHelper.this.worldData.deserializeNBT(tagList2);
                for (Object o : ServerHelper.this.savedData.values()) {
                    if (!(o instanceof Clearable)) continue;
                    ((Clearable)o).clear();
                }
                NBTTagList tagList3 = ServerHelper.fromFile(new File(folder, "savedData.dat")).func_150295_c("savedData", 10);
                ServerHelper.this.savedData.deserializeNBT(tagList3);
                for (Map.Entry entry : ServerHelper.this.extendedSaveData.entrySet()) {
                    if (ServerHelper.this.savedData.keySet().contains(entry.getKey())) continue;
                    try {
                        ServerHelper.this.savedData.put(entry.getKey(), ((Callable)entry.getValue()).call());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                ServerHelper.this.loaded = true;
            }
        }

        @SubscribeEvent
        public void onWorldSave(WorldEvent.Save event) {
            if (ServerHelper.isServer(event.getWorld()) && WorldHelper.getDimID(event.getWorld()) == 0 && event.getWorld().getClass() == WorldServer.class) {
                File folder = new File(event.getWorld().func_72860_G().func_75765_b(), "elec332/");
                ServerHelper.this.toFile(ServerHelper.this.generalData.serializeNBT(), new File(folder, "generalData.dat"));
                NBTTagList tagList1 = ServerHelper.this.playerData.serializeNBT();
                ServerHelper.this.toFile(new NBTHelper().addToTag((NBTBase)tagList1, "playerData").serializeNBT(), new File(folder, "playerData.dat"));
                NBTTagList tagList2 = ServerHelper.this.worldData.serializeNBT();
                ServerHelper.this.toFile(new NBTHelper().addToTag((NBTBase)tagList2, "dimData").serializeNBT(), new File(folder, "worldData.dat"));
                NBTTagList tagList3 = ServerHelper.this.savedData.serializeNBT();
                ServerHelper.this.toFile(new NBTHelper().addToTag((NBTBase)tagList3, "savedData").serializeNBT(), new File(folder, "savedData.dat"));
                ServerHelper.this.loaded = false;
            }
        }

        @SubscribeEvent
        public void playerJoined(PlayerEvent.PlayerLoggedInEvent event) {
            if (!(event.player instanceof EntityPlayerMP)) {
                return;
            }
            if (!ServerHelper.this.locked) {
                ServerHelper.this.locked = true;
            }
            UUID uuid = PlayerHelper.getPlayerUUID(event.player);
            if (!ServerHelper.this.playerData.keySet().contains(uuid)) {
                ElecPlayer player = new ElecPlayer(uuid);
                player.setExtendedProperties(ServerHelper.this.extendedPropertiesList);
                player.deserializeNBT(new NBTTagCompound());
                ServerHelper.this.playerData.put(uuid, player);
            }
            ((ElecPlayer)ServerHelper.this.playerData.get(uuid)).setOnline(true);
        }

        @SubscribeEvent
        public void onPlayerDisconnected(PlayerEvent.PlayerLoggedOutEvent event) {
            if (!(event.player instanceof EntityPlayerMP)) {
                return;
            }
            ElecPlayer player = (ElecPlayer)ServerHelper.this.playerData.get(PlayerHelper.getPlayerUUID(event.player));
            if (player == null) {
                for (int i = 0; i < 30; ++i) {
                    ElecCore.logger.error("A player disconnected from the server without connecting first!");
                    ElecCore.logger.error("Player: " + event.player.func_145748_c_());
                }
                ServerHelper.this.investigateErrors(true);
                return;
            }
            player.setOnline(false);
        }
    }
}

