/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.tile;

import elec332.core.api.wrench.IRightClickCancel;
import elec332.core.api.wrench.IWrenchable;
import elec332.core.tile.IComparatorOverride;
import elec332.core.tile.IRandomDisplayTickProviderTile;
import elec332.core.tile.IRedstoneHandler;
import elec332.core.tile.TileBase;
import elec332.core.util.BlockStateHelper;
import elec332.core.util.DirectionHelper;
import elec332.core.world.WorldHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTileBase
extends Block
implements IWrenchable,
ITileEntityProvider {
    private Class<? extends TileEntity> tileClass;
    private boolean randomDisplayTick;
    private boolean comparatorInputOverride;
    public final String blockName;
    public final String modID;

    public BlockTileBase(Material mat, Class<? extends TileEntity> tileClass, String blockName, String modID) {
        this(mat, tileClass, new ResourceLocation(modID.toLowerCase(), blockName.toLowerCase()));
    }

    public BlockTileBase(Material mat, Class<? extends TileEntity> tileClass, ResourceLocation name) {
        super(mat);
        this.func_149752_b(4.5f);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setRegistryName(name);
        this.func_149663_c(this.getRegistryName().toString().replace(":", ".").toLowerCase());
        this.tileClass = tileClass;
        this.blockName = name.func_110623_a();
        this.modID = name.func_110624_b();
        if (tileClass != null) {
            this.randomDisplayTick = IRandomDisplayTickProviderTile.class.isAssignableFrom(tileClass);
            this.comparatorInputOverride = IComparatorOverride.class.isAssignableFrom(this.tileClass);
        }
    }

    @Deprecated
    public BlockTileBase registerTile() {
        GameRegistry.registerTileEntity(this.tileClass, (String)this.blockName);
        return this;
    }

    public BlockTileBase register() {
        GameRegistry.register((IForgeRegistryEntry)this);
        return this;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176194_O().func_177621_b().func_177226_a(BlockStateHelper.FACING_NORMAL.getProperty(), (Comparable)DirectionHelper.getFacingOnPlacement(placer));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (stack != null && stack.func_77973_b() instanceof IRightClickCancel) {
            return false;
        }
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, pos);
        if (tile instanceof TileBase) {
            return ((TileBase)tile).onBlockActivated(state, player, hand, stack, side, hitX, hitY, hitZ);
        }
        return super.func_180639_a(world, pos, state, player, hand, stack, side, hitX, hitY, hitZ);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer playerIn) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, pos);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onBlockClicked(playerIn);
        }
        super.func_180649_a(world, pos, playerIn);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        try {
            return this.tileClass.newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public ItemStack ItemDropped(World world, BlockPos pos) {
        return new ItemStack((Block)this);
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Override
    public void onWrenched(World world, BlockPos pos, EnumFacing forgeDirection) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, pos);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onWrenched(forgeDirection);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityLiving, ItemStack stack) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, pos);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onBlockPlacedBy(entityLiving, stack);
        }
        super.func_180633_a(world, pos, state, entityLiving, stack);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbor) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, pos);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onNeighborBlockChange(neighbor);
        }
        super.func_189540_a(state, world, pos, neighbor);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity tile = WorldHelper.getTileAt(world, pos);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onNeighborTileChange(neighbor);
        }
        super.onNeighborChange(world, pos, neighbor);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, pos);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onBlockAdded();
        }
        super.func_176213_c(world, pos, state);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, pos);
        if (tile instanceof TileBase) {
            ((TileBase)tile).onBlockRemoved();
        }
        super.func_180663_b(world, pos, state);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = WorldHelper.getTileAt(world, pos);
        if (tile instanceof TileBase) {
            return ((TileBase)tile).getLightValue();
        }
        return super.getLightValue(state, world, pos);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = WorldHelper.getTileAt(world, pos);
        if (tile instanceof TileBase) {
            return ((TileBase)tile).getLightOpacity();
        }
        return super.getLightOpacity(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntity tile;
        if (this.randomDisplayTick && (tile = WorldHelper.getTileAt((IBlockAccess)world, pos)) != null) {
            ((IRandomDisplayTickProviderTile)tile).randomDisplayTick(state, rand);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity tile = WorldHelper.getTileAt(world, pos);
        if (tile instanceof TileBase) {
            return ((TileBase)tile).getDrops(fortune);
        }
        return super.getDrops(world, pos, state, fortune);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = WorldHelper.getTileAt(world, pos);
        if (tile instanceof IRedstoneHandler) {
            return ((IRedstoneHandler)tile).isProvidingWeakPower(side);
        }
        return super.func_180656_a(state, world, pos, side);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction) {
        TileEntity tile = WorldHelper.getTileAt(world, pos);
        if (tile instanceof IRedstoneHandler) {
            return ((IRedstoneHandler)tile).canConnectRedstone(direction);
        }
        return super.canConnectRedstone(state, world, pos, direction);
    }

    public boolean func_149740_M(IBlockState state) {
        return this.comparatorInputOverride;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, pos);
        if (tile instanceof IComparatorOverride) {
            return ((IComparatorOverride)tile).getComparatorInputOverride();
        }
        return super.func_180641_l(state, world, pos);
    }
}

