/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.logging.log4j.Logger;

public abstract class AbstractCompatHandler {
    protected final Configuration configuration;
    private final Logger logger;
    private List<ICompatHandler> compatHandlers;
    private boolean locked;
    protected static final String[] possibleOptions = new String[]{CompatEnabled.FALSE.toString(), CompatEnabled.AUTO.toString(), CompatEnabled.TRUE.toString()};

    public AbstractCompatHandler(Configuration config, Logger logger) {
        if (config != null && this.addCategoryComment()) {
            config.getCategory(this.getCompatCategory()).setComment("Sets if compat for the mod will be enabled, FALSE = always disabled, AUTO = enabled if mod is loaded, TRUE = always enabled (Not recommended, will crash if said mod isn't loaded)");
        }
        this.configuration = config;
        this.logger = logger;
        this.compatHandlers = Lists.newArrayList();
        this.locked = false;
        this.loadList();
    }

    public void addHandler(ICompatHandler handler) {
        if (this.locked) {
            throw new RuntimeException("A mod attempted to register a CompatHandler too late!");
        }
        this.compatHandlers.add(handler);
    }

    public String getCompatCategory() {
        return "compat";
    }

    public boolean addCategoryComment() {
        return true;
    }

    protected List<ICompatHandler> getCompatHandlers() {
        return ImmutableList.copyOf(this.compatHandlers);
    }

    protected ICompatHandler forMod(String mod) {
        for (ICompatHandler compatHandler : this.compatHandlers) {
            if (!compatHandler.getName().equals(mod)) continue;
            return compatHandler;
        }
        return null;
    }

    public void init() {
        this.locked = true;
        for (ICompatHandler handler : this.compatHandlers) {
            if (this.compatEnabled(handler.getType(), handler.compatEnabled(), handler.getName())) {
                this.logger.info(this.getLoadingMessage(handler));
                handler.init();
                continue;
            }
            this.logger.info(this.getHandlerNotLoaded(handler));
        }
    }

    protected String getLoadingMessage(ICompatHandler handler) {
        return "Loading compat handler for: " + handler.getName();
    }

    protected String getHandlerNotLoaded(ICompatHandler handler) {
        return handler.getName() + " was not detected, skipping compat handler for it.";
    }

    public abstract void loadList();

    protected final boolean compatEnabled(String name) {
        return this.compatEnabled(name, ModType.MOD);
    }

    protected final boolean compatEnabled(String name, ModType type) {
        return this.compatEnabled(type, CompatEnabled.AUTO, name);
    }

    protected final boolean compatEnabled(ModType type, CompatEnabled enabled, String name) {
        switch (this.isConfigEnabled(name, enabled)) {
            case FALSE: {
                return false;
            }
            case AUTO: {
                break;
            }
            case TRUE: {
                return true;
            }
        }
        if (type == ModType.API) {
            return AbstractCompatHandler.isAPILoaded(name);
        }
        return Loader.isModLoaded((String)name);
    }

    protected final CompatEnabled isConfigEnabled(String name, CompatEnabled def) {
        CompatEnabled enabled = this.getIsCompatEnabled(name, def);
        return enabled == null ? CompatEnabled.AUTO : enabled;
    }

    protected CompatEnabled getIsCompatEnabled(String mod, CompatEnabled defaultValue) {
        return this.configuration != null ? CompatEnabled.valueOf(this.configuration.getString(mod, this.getCompatCategory(), defaultValue.toString(), "", possibleOptions)) : CompatEnabled.AUTO;
    }

    protected static boolean isAPILoaded(String name) {
        for (ModContainer API2 : ModAPIManager.INSTANCE.getAPIList()) {
            if (!API2.getModId().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static abstract class ICompatHandler {
        public ModType getType() {
            return ModType.MOD;
        }

        public CompatEnabled compatEnabled() {
            return CompatEnabled.AUTO;
        }

        public abstract String getName();

        public abstract void init();
    }

    public static enum ModType {
        MOD,
        API;

    }

    public static enum CompatEnabled {
        FALSE,
        AUTO,
        TRUE;

    }
}

