/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import elec332.core.world.WorldHelper;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DirectionHelper {
    public static final int[][] ROTATION_MATRIX_YAW = new int[][]{{0, 1, 2, 3, 4, 5}, {0, 1, 4, 5, 3, 2}, {0, 1, 3, 2, 5, 4}, {0, 1, 5, 4, 2, 3}};

    public static EnumFacing getFacingOnPlacement(EntityLivingBase entityLivingBase) {
        return DirectionHelper.getDirectionFromNumber(DirectionHelper.getDirectionNumberOnPlacement(entityLivingBase));
    }

    public static int getNumberForDirection(EnumFacing forgeDirection) {
        switch (forgeDirection) {
            case NORTH: {
                return 0;
            }
            case EAST: {
                return 1;
            }
            case SOUTH: {
                return 2;
            }
            case WEST: {
                return 3;
            }
        }
        return -1;
    }

    public static EnumFacing getDirectionFromNumber(int i) {
        switch (i) {
            case 0: {
                return EnumFacing.NORTH;
            }
            case 1: {
                return EnumFacing.EAST;
            }
            case 2: {
                return EnumFacing.SOUTH;
            }
            case 3: {
                return EnumFacing.WEST;
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelRotation getRotationFromFacing(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return ModelRotation.X0_Y270;
            }
            case SOUTH: {
                return ModelRotation.X0_Y180;
            }
            case WEST: {
                return ModelRotation.X0_Y90;
            }
        }
        return ModelRotation.X0_Y0;
    }

    public static EnumFacing rotateLeft(EnumFacing direction) {
        switch (direction) {
            case NORTH: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.NORTH;
            }
        }
        return direction;
    }

    public static EnumFacing rotateRight(EnumFacing direction) {
        switch (direction) {
            case NORTH: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return EnumFacing.NORTH;
            }
        }
        return direction;
    }

    @Deprecated
    public static EnumFacing getOppositeSide(EnumFacing direction) {
        switch (direction) {
            case SOUTH: {
                return EnumFacing.NORTH;
            }
            case WEST: {
                return EnumFacing.EAST;
            }
            case NORTH: {
                return EnumFacing.SOUTH;
            }
            case EAST: {
                return EnumFacing.WEST;
            }
            case UP: {
                return EnumFacing.DOWN;
            }
            case DOWN: {
                return EnumFacing.UP;
            }
        }
        return null;
    }

    public static int getDirectionNumberOnPlacement(EntityLivingBase entityLivingBase) {
        return MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
    }

    @Deprecated
    public static void setFacing_YAW(World world, BlockPos blockPos, EnumFacing forgeDirection) {
        WorldHelper.markBlockForUpdate(world, blockPos);
        throw new UnsupportedOperationException();
    }
}

