/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import elec332.core.util.InventoryHelper;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class DoubleInventory<I1 extends IInventory, I2 extends IInventory>
implements IInventory {
    private I1 inventory1;
    private I2 inventory2;
    private int totalSize;
    private int size1;
    private int size2;

    public DoubleInventory(I1 inv1, I2 inv2) {
        if (inv1 == null || inv2 == null) {
            throw new IllegalArgumentException("Inventory cannot be null!");
        }
        this.inventory1 = inv1;
        this.inventory2 = inv2;
        this.size1 = InventoryHelper.getMainInventorySize(inv1);
        this.size2 = InventoryHelper.getMainInventorySize(inv2);
        this.totalSize = this.size1 + this.size2;
    }

    public static <I1 extends IInventory, I2 extends IInventory> DoubleInventory<I1, I2> fromInventory(I1 i1, I2 i2, DoubleInventory<I1, I2> inventory) {
        DoubleInventory<I1, I2> ret = new DoubleInventory<I1, I2>(i1, i2);
        ret.copyFrom(inventory);
        return ret;
    }

    public int func_70302_i_() {
        return this.totalSize;
    }

    public ItemStack func_70301_a(int i) {
        if (i < this.size1) {
            return this.inventory1.func_70301_a(i);
        }
        return this.inventory2.func_70301_a(i - this.size1);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (slot < this.size1) {
            return this.inventory1.func_70298_a(slot, amount);
        }
        return this.inventory2.func_70298_a(slot - this.size1, amount);
    }

    public ItemStack func_70304_b(int i) {
        if (i < this.size1) {
            return this.inventory1.func_70304_b(i);
        }
        return this.inventory2.func_70304_b(i - this.size1);
    }

    public void func_70299_a(int i, ItemStack stack) {
        if (i < this.size1) {
            this.inventory1.func_70299_a(i, stack);
        } else {
            this.inventory2.func_70299_a(i - this.size1, stack);
        }
    }

    public String func_70005_c_() {
        return this.inventory1.func_70005_c_() + " & " + this.inventory2.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory1.func_145818_k_() || this.inventory2.func_145818_k_();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.inventory1.func_70296_d();
        this.inventory2.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory1.func_70300_a(player) && this.inventory2.func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory1.func_174889_b(player);
        this.inventory2.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory1.func_174886_c(player);
        this.inventory2.func_174886_c(player);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot < this.size1) {
            return this.inventory1.func_94041_b(slot, stack);
        }
        return this.inventory2.func_94041_b(slot - this.size1, stack);
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_174887_a_(int id) {
        return id < this.inventory1.func_174890_g() ? this.inventory1.func_174887_a_(id) : this.inventory2.func_174887_a_(id - this.inventory1.func_174890_g());
    }

    public void func_174885_b(int id, int value) {
        if (id < this.inventory1.func_174890_g()) {
            this.inventory1.func_174885_b(id, value);
        } else {
            this.inventory2.func_174885_b(id - this.inventory1.func_174890_g(), value);
        }
    }

    public int func_174890_g() {
        return this.inventory1.func_174890_g() + this.inventory2.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory1.func_174888_l();
        this.inventory2.func_174888_l();
    }

    public I1 getFirstInventory() {
        return this.inventory1;
    }

    public I2 getSecondInventory() {
        return this.inventory2;
    }

    public boolean addItemToInventory(ItemStack stack) {
        return InventoryHelper.addItemToInventory(this.inventory1, stack) || InventoryHelper.addItemToInventory(this.inventory2, stack);
    }

    public int getFirstSlotWithItemStackNoNBT(ItemStack stack) {
        int i = InventoryHelper.getFirstSlotWithItemStackNoNBT(this.inventory1, stack);
        if (i > -1) {
            return i;
        }
        int q = InventoryHelper.getFirstSlotWithItemStackNoNBT(this.inventory2, stack);
        if (q > -1) {
            return q + this.size1;
        }
        return -1;
    }

    public List<ItemStack> toList() {
        List<ItemStack> ret = InventoryHelper.storeContents(this.inventory1);
        ret.addAll(InventoryHelper.storeContents(this.inventory2));
        return ret;
    }

    public void fromList(List<ItemStack> list) {
        if (list.size() != this.totalSize) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < list.size(); ++i) {
            this.func_70299_a(i, ItemStack.func_77944_b((ItemStack)list.get(i)));
        }
    }

    public void copyTo(I1 i1, I2 i2) {
        int i;
        for (i = 0; i < this.size1; ++i) {
            i1.func_70299_a(i, ItemStack.func_77944_b((ItemStack)this.inventory1.func_70301_a(i)));
        }
        for (i = 0; i < this.size2; ++i) {
            i2.func_70299_a(i, ItemStack.func_77944_b((ItemStack)this.inventory2.func_70301_a(i)));
        }
    }

    public void copyFrom(DoubleInventory<I1, I2> inventory) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, ItemStack.func_77944_b((ItemStack)inventory.func_70301_a(i)));
        }
    }
}

