/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import elec332.core.main.ElecCore;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.FileUtils;

public class IOUtil {
    public static File getBackupFile(@Nonnull File file) throws IOException {
        return new File(file.getCanonicalPath() + "_back");
    }

    public static void createFile(@Nonnull File file) throws IOException {
        if (!(file.exists() || file.getParentFile().mkdirs() || file.createNewFile())) {
            throw new IOException();
        }
    }

    public static class NBT {
        public static NBTTagCompound readWithPossibleBackup(@Nonnull File file) throws IOException {
            try {
                if (!file.exists()) {
                    IOUtil.createFile(file);
                    return new NBTTagCompound();
                }
                return NBT.read(file);
            }
            catch (EOFException e) {
                ElecCore.logger.error("Error reading NBT files, something weird must have happened when you last shutdown MC, unfortunately, some game data will be lost. Fixing file now....");
                String date = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
                String ext = file.getName().replace('.', ' ').split(" ")[1];
                File newFile = new File(file.getCanonicalPath().replace("." + ext, "-" + date + "." + ext));
                FileUtils.moveFile((File)file, (File)newFile);
                IOUtil.createFile(file);
                try {
                    File backup = IOUtil.getBackupFile(file);
                    if (backup.exists()) {
                        return NBT.read(backup);
                    }
                }
                catch (IOException ex) {
                    ElecCore.logger.info("Failed to read backup file: " + file);
                }
                return new NBTTagCompound();
            }
        }

        public static void writeWithBackup(@Nonnull File file, @Nonnull NBTTagCompound tag) throws IOException {
            if (file.exists()) {
                FileUtils.copyFile((File)file, (File)IOUtil.getBackupFile(file));
            }
            NBT.write(file, tag);
        }

        public static void safeWrite(@Nonnull File file, @Nonnull NBTTagCompound tag) throws IOException {
            CompressedStreamTools.func_74793_a((NBTTagCompound)tag, (File)file);
        }

        public static NBTTagCompound read(@Nonnull File file) throws IOException {
            return CompressedStreamTools.func_74797_a((File)file);
        }

        public static void write(@Nonnull File file, @Nonnull NBTTagCompound tag) throws IOException {
            CompressedStreamTools.func_74795_b((NBTTagCompound)tag, (File)file);
        }
    }
}

