/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import com.google.common.base.Function;
import elec332.core.util.EnumHelper;
import elec332.core.util.INBTSavable;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class NBTHelper
implements INBTSerializable<NBTTagCompound> {
    private NBTTagCompound tagCompound;

    public NBTHelper() {
        this(new NBTTagCompound());
    }

    public NBTHelper(NBTHelper mainTag) {
        this(mainTag.tagCompound);
    }

    public NBTHelper(NBTTagCompound tagCompound) {
        this.tagCompound = tagCompound;
    }

    public NBTHelper addToTag(INBTSavable nbtSavable, String s) {
        nbtSavable.writeToNBT(this.tagCompound, s);
        return this;
    }

    public NBTHelper addToTag(List<String> list, String s) {
        if (list.size() > 0) {
            NBTTagList tagList = new NBTTagList();
            for (String string : list) {
                tagList.func_74742_a((NBTBase)new NBTHelper().addToTag(string, s).toNBT());
            }
            this.tagCompound.func_74782_a(s, (NBTBase)tagList);
        }
        return this;
    }

    public NBTHelper addToTag(int i, String s) {
        this.tagCompound.func_74768_a(s, i);
        return this;
    }

    public NBTHelper addToTag(UUID uuid, String s) {
        this.tagCompound.func_186854_a(s, uuid);
        return this;
    }

    public NBTHelper addToTag(String data, String saveName) {
        this.tagCompound.func_74778_a(saveName, data);
        return this;
    }

    public NBTHelper addToTag(boolean b, String s) {
        this.tagCompound.func_74757_a(s, b);
        return this;
    }

    public NBTHelper addToTag(float f, String s) {
        this.tagCompound.func_74776_a(s, f);
        return this;
    }

    public NBTHelper addToTag(BlockPos pos) {
        return this.addToTag(pos, "blockLoc");
    }

    public NBTHelper addToTag(BlockPos pos, String s) {
        return this.addToTag(new NBTHelper().addToTag(pos.func_177958_n(), "x").addToTag(pos.func_177956_o(), "y").addToTag(pos.func_177952_p(), "z"), s);
    }

    public NBTHelper addToTag(Long l, String s) {
        this.tagCompound.func_74772_a(s, l.longValue());
        return this;
    }

    public NBTHelper addToTag(NBTHelper nbt, String s) {
        return this.addToTag((NBTBase)nbt.tagCompound, s);
    }

    public NBTHelper addToTag(NBTBase nbtBase, String s) {
        this.tagCompound.func_74782_a(s, nbtBase);
        return this;
    }

    public NBTHelper addToTag(Enum e, String s) {
        return this.addToTag(EnumHelper.getName(e), s);
    }

    public BlockPos getPos() {
        return this.getPos("blockLoc");
    }

    public BlockPos getPos(String s) {
        NBTTagCompound tag = this.getCompoundTag(s);
        return new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    public long getLong(String s) {
        return this.tagCompound.func_74763_f(s);
    }

    public int getInteger(String s) {
        return this.tagCompound.func_74762_e(s);
    }

    public NBTTagCompound getCompoundTag(String s) {
        return this.tagCompound.func_74775_l(s);
    }

    public String getString(String s) {
        return this.tagCompound.func_74779_i(s);
    }

    public UUID getUUID(String s) {
        return this.tagCompound.func_186857_a(s);
    }

    public <E extends Enum> E getEnum(String s, Class<E> c) {
        return EnumHelper.fromString(this.getString(s), c);
    }

    @Deprecated
    public NBTTagCompound toNBT() {
        return this.tagCompound;
    }

    public NBTTagCompound serializeNBT() {
        return this.tagCompound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.tagCompound = nbt;
    }

    public static class DefaultFunction<F>
    implements Function<F, NBTHelper> {
        public NBTHelper apply(F input) {
            return new NBTHelper();
        }
    }

    public static class DefaultCallable
    implements Callable<NBTHelper> {
        @Override
        public NBTHelper call() throws Exception {
            return new NBTHelper();
        }
    }
}

