/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import elec332.core.main.ElecCore;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;

public class OredictHelper {
    private static List<String> allOres = Lists.newArrayList();
    private static List<String> allIngots = Lists.newArrayList();
    private static List<String> allDusts = Lists.newArrayList();

    public static void registerRecipeSorter(ResourceLocation name, Class<? extends IRecipe> recipeClass) {
        OredictHelper.registerRecipeSorter(name, recipeClass, RecipeSorter.Category.SHAPELESS);
    }

    public static void registerRecipeSorter(ResourceLocation name, Class<? extends IRecipe> recipeClass, RecipeSorter.Category category) {
        RecipeSorter.register((String)name.toString(), recipeClass, (RecipeSorter.Category)category, (String)"");
    }

    public static void initLists() {
        allDusts.clear();
        allIngots.clear();
        allOres.clear();
        String[] names = OreDictionary.getOreNames();
        for (int i = 0; i < names.length; ++i) {
            String s = names[i];
            if (s == null) {
                ElecCore.systemPrintDebug("Null ore for ID: " + i);
                continue;
            }
            if (s.startsWith("ore")) {
                allOres.add(s);
                continue;
            }
            if (s.startsWith("ingot")) {
                allIngots.add(s);
                continue;
            }
            if (!s.startsWith("dust")) continue;
            allDusts.add(s);
        }
    }

    public static List<String> getAllOres() {
        return ImmutableList.copyOf(allOres);
    }

    public static List<String> getAllIngots() {
        return ImmutableList.copyOf(allIngots);
    }

    public static List<String> getAllDusts() {
        return ImmutableList.copyOf(allDusts);
    }

    public static String concatOreName(String oreName) {
        return oreName.replace("ore", "");
    }

    public static String concatIngotName(String ingotName) {
        return ingotName.replace("ingot", "");
    }

    public static boolean isOre(ItemStack stack) {
        return OredictHelper.getOreIDs(stack).length > 0;
    }

    public static List<String> getOreNames(ItemStack stack) {
        ArrayList ret = Lists.newArrayList();
        for (int i : OredictHelper.getOreIDs(stack)) {
            ret.add(OreDictionary.getOreName((int)i));
        }
        return ret;
    }

    public static int[] getOreIDs(ItemStack stack) {
        return OreDictionary.getOreIDs((ItemStack)stack);
    }

    @Deprecated
    public static Item getFirstOredictEntry(String Oredictname) {
        return OredictHelper.getOredictEntry(0, Oredictname);
    }

    @Deprecated
    public static Item getOredictEntry(int number, String Oredictname) {
        return ((ItemStack)OreDictionary.getOres((String)Oredictname).get(number)).func_77973_b();
    }

    @Deprecated
    public static int getFirstOredictItemDamage(String Oredictname) {
        return OredictHelper.getOredictItemDamage(0, Oredictname);
    }

    @Deprecated
    public static int getOredictItemDamage(int number, String OreDictname) {
        return ((ItemStack)OreDictionary.getOres((String)OreDictname).get(number)).func_77952_i();
    }

    @Deprecated
    public static ItemStack getFirstOreDictItemWithMeta(String Oredictname) {
        return OredictHelper.getOreDictItemWithMeta(Oredictname, 0);
    }

    @Deprecated
    public static ItemStack getOreDictItemWithMeta(String Oredictname, int entry) {
        return new ItemStack(OredictHelper.getOredictEntry(entry, Oredictname), 1, OredictHelper.getOredictItemDamage(entry, Oredictname));
    }

    static {
        OredictHelper.initLists();
    }
}

