/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.world;

import com.google.common.base.Predicate;
import elec332.core.util.WorldGenInfo;
import java.io.File;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public abstract class WorldGen
implements IWorldGenerator {
    public static final Predicate<IBlockState> STONE = BlockMatcher.func_177642_a((Block)Blocks.field_150348_b);
    public static final Predicate<IBlockState> NETHERRACK = BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL);
    public static final Predicate<IBlockState> ENDSTONE = BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs);
    private Configuration configuration;

    public WorldGen(File configFile) {
        this.configuration = new Configuration(configFile);
    }

    public WorldGenInfo configurableWorldGen(String oreName, int clusterSize, int maxY, int timesPerChunk, Block block) {
        return this.configurableWorldGen(oreName, clusterSize, maxY, timesPerChunk, block, 0);
    }

    public WorldGenInfo configurableWorldGen(String oreName, int clusterSize, int maxY, int timesPerChunk, Block block, int meta) {
        this.configuration.load();
        boolean s = this.configuration.getBoolean("Should_gen", oreName, true, "Sets if the ore should generate in the world or not");
        int m = this.configuration.getInt("Generation_multiplier", oreName, 100, 0, 1000, "Sets how many times the mod will attempt to generate ores per chunk (In % from the default value)");
        int c = this.configuration.getInt("ClusterSize", oreName, clusterSize, 0, 30, "Sets the max cluster size for this ore");
        if (this.configuration.hasChanged()) {
            this.configuration.save();
        }
        return new WorldGenInfo(maxY, timesPerChunk, block, meta).setGenerationMultiplier((float)m / 100.0f).setShouldGen(s).setClusterSize(c);
    }

    public void register() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)1000);
    }

    public void generateEnd(World world, Random random, int chunkX, int chunkZ, WorldGenInfo info) {
        if (info.getShouldGen().booleanValue()) {
            int i = 0;
            while ((float)i < (float)info.timesPerChunk * info.getGenerationMultiplier()) {
                int xCoord = chunkX * 16 + random.nextInt(16);
                int yCoord = random.nextInt(info.yLevelMax);
                int zCoord = chunkZ * 16 + random.nextInt(16);
                new WorldGenMinable(info.block.func_176203_a(info.meta), info.getClusterSize(), ENDSTONE).func_180709_b(world, random, new BlockPos(xCoord, yCoord, zCoord));
                ++i;
            }
        }
    }

    public void generateNether(World world, Random random, int chunkX, int chunkZ, WorldGenInfo info) {
        if (info.getShouldGen().booleanValue()) {
            int i = 0;
            while ((float)i < (float)info.timesPerChunk * info.getGenerationMultiplier()) {
                int xCoord = chunkX * 16 + random.nextInt(16);
                int yCoord = random.nextInt(info.yLevelMax);
                int zCoord = chunkZ * 16 + random.nextInt(16);
                new WorldGenMinable(info.block.func_176203_a(info.meta), info.getClusterSize(), NETHERRACK).func_180709_b(world, random, new BlockPos(xCoord, yCoord, zCoord));
                ++i;
            }
        }
    }

    public void generateOverworld(World world, Random random, int chunkX, int chunkZ, WorldGenInfo info) {
        if (info.getShouldGen().booleanValue()) {
            int i = 0;
            while ((float)i < (float)info.timesPerChunk * info.getGenerationMultiplier()) {
                int xCoord = chunkX * 16 + random.nextInt(16);
                int yCoord = random.nextInt(info.yLevelMax);
                int zCoord = chunkZ * 16 + random.nextInt(16);
                new WorldGenMinable(info.block.func_176203_a(info.meta), info.getClusterSize(), STONE).func_180709_b(world, random, new BlockPos(xCoord, yCoord, zCoord));
                ++i;
            }
        }
    }
}

