/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.world;

import elec332.core.main.ElecCore;
import elec332.core.network.PacketReRenderBlock;
import elec332.core.server.ServerHelper;
import elec332.core.util.NBTHelper;
import elec332.core.util.PlayerHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;

public class WorldHelper {
    public static ChunkPos chunkCoordFromBlockPos(BlockPos pos) {
        return new ChunkPos(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public static long longFromBlockPos(BlockPos pos) {
        return ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
    }

    public static long longFromChunk(Chunk chunk) {
        return WorldHelper.longFromChunkXZ(chunk.func_76632_l());
    }

    public static long longFromChunkXZ(ChunkPos chunkCoordIntPair) {
        return ChunkPos.func_77272_a((int)chunkCoordIntPair.field_77276_a, (int)chunkCoordIntPair.field_77275_b);
    }

    public static void reRenderBlock(TileEntity tile) {
        if (!tile.func_145831_w().field_72995_K) {
            ServerHelper.instance.sendMessageToAllPlayersWatchingBlock(tile.func_145831_w(), tile.func_174877_v(), new PacketReRenderBlock(tile), ElecCore.networkHandler);
        } else {
            WorldHelper.markBlockForRenderUpdate(tile.func_145831_w(), tile.func_174877_v());
        }
    }

    public static void setBlockState(World world, BlockPos pos, IBlockState state, int flags) {
        world.func_180501_a(pos, state, flags);
    }

    public static void markBlockForUpdate(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            ((WorldServer)world).func_184164_w().func_180244_a(pos);
        } else {
            world.func_175704_b(pos, pos);
        }
    }

    public static boolean chunkLoaded(World world, BlockPos pos) {
        Chunk chunk = world.func_72863_F().func_186026_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        return chunk == null || chunk.func_177410_o();
    }

    public static void markBlockForRenderUpdate(World world, BlockPos pos) {
        world.func_175704_b(pos, pos);
    }

    public static void spawnExplosion(World worldObj, int xCoord, int yCoord, int zCoord, float force) {
        worldObj.func_72876_a(null, (double)xCoord, (double)yCoord, (double)zCoord, force * 4.0f, true);
    }

    public static ForgeChunkManager.Ticket requestTicket(World world, BlockPos loc, Object modInstance) {
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)modInstance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (ticket != null) {
            new NBTHelper(ticket.getModData()).addToTag(loc);
        }
        return ticket;
    }

    public static ChunkPos fromBlockLoc(BlockPos loc) {
        return new ChunkPos(loc.func_177958_n() >> 4, loc.func_177952_p() >> 4);
    }

    public static void forceChunk(ForgeChunkManager.Ticket ticket) {
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)WorldHelper.fromBlockLoc(new NBTHelper(ticket.getModData()).getPos()));
    }

    public static void dropStack(World world, BlockPos blockLoc, ItemStack stack) {
        WorldHelper.dropStack(world, blockLoc.func_177958_n(), blockLoc.func_177956_o(), blockLoc.func_177952_p(), stack);
    }

    public static void dropStack(World world, int x, int y, int z, ItemStack itemStack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, itemStack);
            entityitem.func_174869_p();
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void scheduleBlockUpdate(World world, BlockPos blockLoc) {
        world.func_175684_a(blockLoc, WorldHelper.getBlockAt((IBlockAccess)world, blockLoc), 1);
    }

    public static int getDimID(World world) {
        if (world == null) {
            throw new IllegalArgumentException("Cannot fetch the Dimension-ID from a null world!");
        }
        if (world.field_73011_w == null) {
            for (Integer i : DimensionManager.getIDs()) {
                if (DimensionManager.getWorld((int)i) != world) continue;
                return i;
            }
            throw new RuntimeException("Unable to determine the dimension of world: " + world);
        }
        return world.field_73011_w.getDimension();
    }

    public static int getBlockMeta(IBlockAccess world, BlockPos blockLoc) {
        return WorldHelper.getBlockMeta(WorldHelper.getBlockState(world, blockLoc));
    }

    public static int getBlockMeta(IBlockState state) {
        return state.func_177230_c().func_176201_c(state);
    }

    public static TileEntity getTileAt(IBlockAccess world, BlockPos loc) {
        return world.func_175625_s(loc);
    }

    public static Block getBlockAt(IBlockAccess world, BlockPos loc) {
        return WorldHelper.getBlockState(world, loc).func_177230_c();
    }

    public static IBlockState getBlockState(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos);
    }

    public static void spawnLightningAtLookVec(EntityPlayer player, Double range) {
        RayTraceResult position = PlayerHelper.getPosPlayerIsLookingAt(player, range);
        WorldHelper.spawnLightningAt(player.field_70170_p, position.func_178782_a());
    }

    public static void spawnLightningAt(World world, BlockPos blockPos) {
        WorldHelper.spawnLightningAt(world, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    public static void spawnLightningAt(World world, double x, double y, double z) {
        world.func_72838_d((Entity)new EntityLightningBolt(world, x, y, z, false));
    }
}

