/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.world.schematic;

import com.google.common.collect.Maps;
import elec332.core.api.structure.ISchematic;
import elec332.core.world.schematic.Area;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;

public class Schematic
implements ISchematic {
    protected final NBTTagList tileDataList;
    public short width;
    public short height;
    public short length;
    public short horizon;
    public byte[] data;
    public Block[] blocks;
    private Map<BlockPos, NBTTagCompound> tiles;
    public int areaBlockCount;

    protected Schematic(NBTTagList tileEntities, short width, short height, short length, short horizon, byte[] data, Block[] blocks) {
        this.tileDataList = tileEntities;
        this.width = width;
        this.height = height;
        this.length = length;
        this.horizon = horizon;
        this.data = data;
        this.blocks = blocks;
        this.areaBlockCount = width * height * length;
        this.tiles = Maps.newHashMap();
        this.reloadTileMap();
    }

    private void reloadTileMap() {
        this.tiles.clear();
        for (int i = 0; i < this.tileDataList.func_74745_c(); ++i) {
            NBTTagCompound tag = (NBTTagCompound)this.tileDataList.func_150305_b(i).func_74737_b();
            BlockPos pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
            this.tiles.put(pos, tag);
        }
    }

    public Block getBlock(BlockPos pos) {
        return this.getBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public Block getBlock(int x, int y, int z) {
        return this.blocks[this.getIndexFromCoordinates(x, y, z)];
    }

    @Override
    public NBTTagCompound getTileData(int x, int y, int z, int worldX, int worldY, int worldZ) {
        NBTTagCompound tag = this.getTileData(x, y, z);
        if (tag != null) {
            tag.func_74768_a("x", worldX);
            tag.func_74768_a("y", worldY);
            tag.func_74768_a("z", worldZ);
            return tag;
        }
        return null;
    }

    @Override
    public NBTTagCompound getTileData(int x, int y, int z) {
        NBTTagCompound tag = this.tiles.get(new BlockPos(x, y, z));
        if (tag != null) {
            return (NBTTagCompound)tag.func_74737_b();
        }
        return null;
    }

    public byte getMetaData(BlockPos pos) {
        return this.getMetadata(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public byte getMetadata(int x, int y, int z) {
        return this.data[this.getIndexFromCoordinates(x, y, z)];
    }

    public Area getAreaFromWorldCoordinates(int x, int y, int z) {
        int maxZ;
        int minZ;
        int maxX;
        int minX;
        if (this.width % 2 == 0) {
            minX = x + 1 - this.width / 2;
            maxX = x + this.width / 2;
        } else {
            minX = x - (this.width - 1) / 2;
            maxX = x + (this.width - 1) / 2;
        }
        int minY = y - this.horizon;
        int maxY = y - this.horizon + this.height;
        if (this.length % 2 == 0) {
            minZ = z + 1 - this.length / 2;
            maxZ = z + this.length / 2;
        } else {
            minZ = z - (this.length - 1) / 2;
            maxZ = z + (this.length - 1) / 2;
        }
        return new Area(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public IBlockState getState(BlockPos pos) {
        return this.getBlock(pos).func_176203_a((int)this.getMetaData(pos));
    }

    protected int getIndexFromCoordinates(int x, int y, int z) {
        return y * this.width * this.length + z * this.width + x;
    }
}

