/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.world.schematic;

import com.google.common.collect.Maps;
import elec332.core.main.ElecCore;
import elec332.core.util.FileHelper;
import elec332.core.util.NBT;
import elec332.core.world.WorldHelper;
import elec332.core.world.schematic.Area;
import elec332.core.world.schematic.Schematic;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class SchematicHelper {
    public static final SchematicHelper INSTANCE = new SchematicHelper();

    public Schematic loadSchematic(File file) {
        try {
            return this.loadSchematic(new FileInputStream(file));
        }
        catch (IOException e) {
            ElecCore.logger.fatal("Error loading schematic at: " + file);
            ElecCore.logger.fatal((Object)e);
            return null;
        }
    }

    public Schematic loadSchematic(ResourceLocation rl) {
        try {
            return this.loadSchematic(FileHelper.getFromResource(rl));
        }
        catch (IOException e) {
            ElecCore.logger.fatal("Error loading schematic at: " + rl);
            ElecCore.logger.fatal((Object)e);
            return null;
        }
    }

    public Schematic loadSchematic(InputStream is) {
        try {
            NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)is);
            is.close();
            return this.loadModSchematic(tag);
        }
        catch (Exception e) {
            ElecCore.logger.fatal("Error loading schematic.");
            ElecCore.logger.fatal((Object)e);
            return null;
        }
    }

    public Schematic loadModSchematic(NBTTagCompound nbt) {
        try {
            int i;
            NBTTagList tileEntities = nbt.func_150295_c("TileEntities", (int)NBT.NBTData.COMPOUND.getID());
            short width = nbt.func_74765_d("Width");
            short height = nbt.func_74765_d("Height");
            short length = nbt.func_74765_d("Length");
            short horizon = nbt.func_74765_d("Horizon");
            NBTTagList blockData = nbt.func_150295_c("BlockData", (int)NBT.NBTData.COMPOUND.getID());
            byte[] metadata = nbt.func_74770_j("Data");
            int[] blockArray = nbt.func_74759_k("Blocks");
            Block[] blocks = new Block[width * height * length];
            HashMap idMap = Maps.newHashMap();
            idMap.put(-1, Blocks.field_150350_a);
            for (i = 0; i < blockData.func_74745_c(); ++i) {
                NBTTagCompound tag = blockData.func_150305_b(i);
                idMap.put(tag.func_74762_e("p"), GameData.getBlockRegistry().getObject(new ResourceLocation(tag.func_74779_i("m"), tag.func_74779_i("b"))));
            }
            for (i = 0; i < blockArray.length; ++i) {
                blocks[i] = (Block)idMap.get(blockArray[i]);
            }
            return new Schematic(tileEntities, width, height, length, horizon, metadata, blocks);
        }
        catch (Exception ex) {
            ElecCore.logger.fatal("Error loading ModSchematic.");
            ElecCore.logger.fatal((Object)ex);
            return null;
        }
    }

    public NBTTagCompound writeSchematic(Schematic schematic) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("Width", schematic.width);
        nbt.func_74777_a("Height", schematic.height);
        nbt.func_74777_a("Length", schematic.length);
        nbt.func_74777_a("Horizon", schematic.horizon);
        nbt.func_74773_a("Data", schematic.data);
        nbt.func_74782_a("TileEntities", (NBTBase)schematic.tileDataList);
        int[] blocks = new int[schematic.blocks.length];
        NBTTagList blockData = new NBTTagList();
        HashMap map = Maps.newHashMap();
        int id = 0;
        for (int i = 0; i < schematic.blocks.length; ++i) {
            Block block = schematic.blocks[i];
            if (block != Blocks.field_150350_a) {
                if (!map.containsKey(block)) {
                    NBTTagCompound tag = new NBTTagCompound();
                    int ID = id++;
                    tag.func_74768_a("p", ID);
                    map.put(block, ID);
                    ResourceLocation rl = GameData.getBlockRegistry().getNameForObject((IForgeRegistryEntry)block);
                    tag.func_74778_a("m", rl.func_110624_b());
                    tag.func_74778_a("b", rl.func_110623_a());
                    blockData.func_74742_a((NBTBase)tag);
                }
                blocks[i] = (Integer)map.get(block);
                continue;
            }
            blocks[i] = -1;
        }
        nbt.func_74783_a("Blocks", blocks);
        nbt.func_74782_a("BlockData", (NBTBase)blockData);
        return nbt;
    }

    public Schematic createModSchematic(World world, Area area, short horizon) {
        if (world == null || area == null) {
            return null;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("Width", area.getWidth());
        nbt.func_74777_a("Height", area.getHeight());
        nbt.func_74777_a("Length", area.getLength());
        nbt.func_74777_a("Horizon", horizon);
        Block[] blocks = new Block[area.getBlockCount()];
        byte[] data = new byte[area.getBlockCount()];
        NBTTagList tileList = new NBTTagList();
        int i = 0;
        int schematicY = 0;
        for (int y = Math.min(area.y1, area.y2); y <= Math.max(area.y1, area.y2); ++y) {
            int schematicZ = 0;
            for (int z = Math.min(area.z1, area.z2); z <= Math.max(area.z1, area.z2); ++z) {
                int schematicX = 0;
                for (int x = Math.min(area.x1, area.x2); x <= Math.max(area.x1, area.x2); ++x) {
                    BlockPos pos = new BlockPos(x, y, z);
                    blocks[i] = WorldHelper.getBlockAt((IBlockAccess)world, pos);
                    data[i] = (byte)WorldHelper.getBlockMeta((IBlockAccess)world, pos);
                    TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, pos);
                    if (tile != null) {
                        NBTTagCompound tileNBT = new NBTTagCompound();
                        tile.func_189515_b(tileNBT);
                        tileNBT.func_74768_a("x", schematicX);
                        tileNBT.func_74768_a("y", schematicY);
                        tileNBT.func_74768_a("z", schematicZ);
                        tileList.func_74742_a((NBTBase)tileNBT);
                    }
                    ++i;
                    ++schematicX;
                }
                ++schematicZ;
            }
            ++schematicY;
        }
        return new Schematic(tileList, area.getWidth(), area.getHeight(), area.getLength(), horizon, data, blocks);
    }
}

