/*
 * Decompiled with CFR 0.152.
 */
package portablejim.bbw.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.FMLLog;
import portablejim.bbw.BetterBuildersWandsMod;
import portablejim.bbw.basics.EnumFluidLock;
import portablejim.bbw.basics.EnumLock;
import portablejim.bbw.basics.Point3d;
import portablejim.bbw.core.conversion.CustomMapping;
import portablejim.bbw.core.wands.IWand;
import portablejim.bbw.shims.IPlayerShim;
import portablejim.bbw.shims.IWorldShim;

public class WandWorker {
    private final IWand wand;
    private final IPlayerShim player;
    private final IWorldShim world;
    HashSet<Point3d> allCandidates = new HashSet();

    public WandWorker(IWand wand, IPlayerShim player, IWorldShim world) {
        this.wand = wand;
        this.player = player;
        this.world = world;
    }

    public ItemStack getProperItemStack(IWorldShim world, IPlayerShim player, Point3d blockPos) {
        int meta;
        Block block = world.getBlock(blockPos);
        ItemStack exactItemstack = new ItemStack(block, 1, meta = world.getMetadata(blockPos));
        if (player.countItems(exactItemstack) > 0) {
            return exactItemstack;
        }
        return this.getEquivalentItemStack(blockPos);
    }

    public ItemStack getEquivalentItemStack(Point3d blockPos) {
        Block block = this.world.getBlock(blockPos);
        int meta = this.world.getMetadata(blockPos);
        ItemStack stack = null;
        CustomMapping customMapping = BetterBuildersWandsMod.instance.mappingManager.getMapping(block, meta);
        if (customMapping != null) {
            stack = customMapping.getItems();
        } else if (block.canSilkHarvest(this.world.getWorld(), blockPos.toBlockPos(), block.func_176203_a(meta), this.player.getPlayer())) {
            stack = BetterBuildersWandsMod.instance.blockCache.getStackedBlock(this.world, blockPos);
        } else {
            Item dropped = block.func_180660_a(block.func_176203_a(meta), new Random(), 0);
            if (dropped != null) {
                stack = new ItemStack(dropped, block.quantityDropped(block.func_176203_a(meta), 0, new Random()), block.func_180651_a(block.func_176203_a(meta)));
            }
        }
        return stack;
    }

    private boolean shouldContinue(Point3d currentCandidate, Block targetBlock, int targetMetadata, EnumFacing facing, Block candidateSupportingBlock, int candidateSupportingMeta, AxisAlignedBB blockBB, EnumFluidLock fluidLock) {
        if (!this.world.blockIsAir(currentCandidate)) {
            Block currrentCandidateBlock = this.world.getBlock(currentCandidate);
            if (fluidLock != EnumFluidLock.IGNORE || currrentCandidateBlock == null || !(currrentCandidateBlock instanceof IFluidBlock) && !(currrentCandidateBlock instanceof BlockLiquid)) {
                return false;
            }
        }
        if (!targetBlock.equals(candidateSupportingBlock)) {
            return false;
        }
        if (targetMetadata != candidateSupportingMeta) {
            return false;
        }
        if (!targetBlock.func_176196_c(this.world.getWorld(), new BlockPos(currentCandidate.x, currentCandidate.y, currentCandidate.z))) {
            return false;
        }
        if (!targetBlock.func_176193_a(this.world.getWorld(), new BlockPos(currentCandidate.x, currentCandidate.y, currentCandidate.z), facing, new ItemStack(candidateSupportingBlock, 1, candidateSupportingMeta))) {
            return false;
        }
        return !this.world.entitiesInBox(blockBB);
    }

    public LinkedList<Point3d> getBlockPositionList(Point3d blockLookedAt, EnumFacing placeDirection, int maxBlocks, EnumLock directionLock, EnumLock faceLock, EnumFluidLock fluidLock) {
        LinkedList<Point3d> candidates = new LinkedList<Point3d>();
        LinkedList<Point3d> toPlace = new LinkedList<Point3d>();
        Block targetBlock = this.world.getBlock(blockLookedAt);
        int targetMetadata = this.world.getMetadata(blockLookedAt);
        Point3d startingPoint = blockLookedAt.move(placeDirection);
        int directionMaskInt = directionLock.mask;
        int faceMaskInt = faceLock.mask;
        if ((directionLock != EnumLock.HORIZONTAL && directionLock != EnumLock.VERTICAL || placeDirection != EnumFacing.UP && placeDirection != EnumFacing.DOWN) && (directionLock != EnumLock.NORTHSOUTH || placeDirection != EnumFacing.NORTH && placeDirection != EnumFacing.SOUTH) && (directionLock != EnumLock.EASTWEST || placeDirection != EnumFacing.EAST && placeDirection != EnumFacing.WEST)) {
            candidates.add(startingPoint);
        }
        while (candidates.size() > 0 && toPlace.size() < maxBlocks) {
            AxisAlignedBB blockBB;
            int candidateSupportingMeta;
            Point3d supportingPoint;
            Block candidateSupportingBlock;
            Point3d currentCandidate = (Point3d)candidates.removeFirst();
            if (!this.shouldContinue(currentCandidate, targetBlock, targetMetadata, placeDirection, candidateSupportingBlock = this.world.getBlock(supportingPoint = currentCandidate.move(placeDirection.func_176734_d())), candidateSupportingMeta = this.world.getMetadata(supportingPoint), blockBB = targetBlock.func_176203_a(targetMetadata).func_185900_c((IBlockAccess)this.world.getWorld(), new BlockPos(currentCandidate.x, currentCandidate.y, currentCandidate.z)), fluidLock) || !this.allCandidates.add(currentCandidate)) continue;
            toPlace.add(currentCandidate);
            switch (placeDirection) {
                case DOWN: 
                case UP: {
                    if ((faceMaskInt & 2) <= 0) break;
                    if ((directionMaskInt & 1) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.NORTH));
                    }
                    if ((directionMaskInt & 4) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.EAST));
                    }
                    if ((directionMaskInt & 1) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.SOUTH));
                    }
                    if ((directionMaskInt & 4) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.WEST));
                    }
                    if ((directionMaskInt & 1) <= 0 || (directionMaskInt & 4) <= 0) break;
                    candidates.add(currentCandidate.move(EnumFacing.NORTH).move(EnumFacing.EAST));
                    candidates.add(currentCandidate.move(EnumFacing.NORTH).move(EnumFacing.WEST));
                    candidates.add(currentCandidate.move(EnumFacing.SOUTH).move(EnumFacing.EAST));
                    candidates.add(currentCandidate.move(EnumFacing.SOUTH).move(EnumFacing.WEST));
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    if ((faceMaskInt & 1) <= 0) break;
                    if ((directionMaskInt & 2) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.UP));
                    }
                    if ((directionMaskInt & 4) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.EAST));
                    }
                    if ((directionMaskInt & 2) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.DOWN));
                    }
                    if ((directionMaskInt & 4) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.WEST));
                    }
                    if ((directionMaskInt & 2) <= 0 || (directionMaskInt & 4) <= 0) break;
                    candidates.add(currentCandidate.move(EnumFacing.UP).move(EnumFacing.EAST));
                    candidates.add(currentCandidate.move(EnumFacing.UP).move(EnumFacing.WEST));
                    candidates.add(currentCandidate.move(EnumFacing.DOWN).move(EnumFacing.EAST));
                    candidates.add(currentCandidate.move(EnumFacing.DOWN).move(EnumFacing.WEST));
                    break;
                }
                case WEST: 
                case EAST: {
                    if ((faceMaskInt & 4) <= 0) break;
                    if ((directionMaskInt & 2) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.UP));
                    }
                    if ((directionMaskInt & 1) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.NORTH));
                    }
                    if ((directionMaskInt & 2) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.DOWN));
                    }
                    if ((directionMaskInt & 1) > 0) {
                        candidates.add(currentCandidate.move(EnumFacing.SOUTH));
                    }
                    if ((directionMaskInt & 2) <= 0 || (directionMaskInt & 1) <= 0) break;
                    candidates.add(currentCandidate.move(EnumFacing.UP).move(EnumFacing.NORTH));
                    candidates.add(currentCandidate.move(EnumFacing.UP).move(EnumFacing.SOUTH));
                    candidates.add(currentCandidate.move(EnumFacing.DOWN).move(EnumFacing.NORTH));
                    candidates.add(currentCandidate.move(EnumFacing.DOWN).move(EnumFacing.SOUTH));
                }
            }
        }
        return toPlace;
    }

    public ArrayList<Point3d> placeBlocks(ItemStack wandItem, LinkedList<Point3d> blockPosList, Point3d originalBlock, ItemStack sourceItems, EnumFacing side, float hitX, float hitY, float hitZ) {
        ArrayList<Point3d> placedBlocks = new ArrayList<Point3d>();
        for (Point3d blockPos : blockPosList) {
            boolean takeFromInventory;
            CustomMapping mapping = BetterBuildersWandsMod.instance.mappingManager.getMapping(this.world.getBlock(originalBlock), this.world.getMetadata(originalBlock));
            boolean blockPlaceSuccess = mapping != null ? this.world.setBlock(blockPos, mapping.getPlaceBlock(), mapping.getPlaceMeta()) : this.world.copyBlock(originalBlock, blockPos);
            if (!blockPlaceSuccess) continue;
            Item itemFromBlock = Item.func_150898_a((Block)this.world.getBlock(originalBlock));
            this.world.playPlaceAtBlock(blockPos, this.world.getBlock(originalBlock));
            placedBlocks.add(blockPos);
            if (!this.player.isCreative()) {
                this.wand.placeBlock(wandItem, (EntityLivingBase)this.player.getPlayer());
            }
            if (takeFromInventory = this.player.useItem(sourceItems)) continue;
            FMLLog.info((String)"BBW takeback: %s", (Object[])new Object[]{blockPos.toString()});
            this.world.setBlockToAir(blockPos);
            placedBlocks.remove(placedBlocks.size() - 1);
        }
        return placedBlocks;
    }
}

