/*
 * Decompiled with CFR 0.152.
 */
package portablejim.bbw.core.conversion;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import portablejim.bbw.BetterBuildersWandsMod;
import portablejim.bbw.core.conversion.CustomMapping;

public class CustomMappingManager {
    ArrayList<CustomMapping> mappings = new ArrayList();

    public void loadConfig(String configString) {
        String[] split;
        if (configString.trim().isEmpty()) {
            return;
        }
        for (String part : split = configString.trim().split(",")) {
            CustomMapping customMapping = this.parseMappingString(part);
            if (customMapping == null) continue;
            this.mappings.add(customMapping);
        }
    }

    public CustomMapping parseMappingString(String mappingString) {
        String REGEX = "^(\\w[^:]+:[^/]+)/(\\d+)=>(\\d)+\\*(\\w[^:]+:[^/]+)/(\\d+)=>(\\w[^:]+:[^/]+)/(\\d+)$";
        Pattern p = Pattern.compile("^(\\w[^:]+:[^/]+)/(\\d+)=>(\\d)+\\*(\\w[^:]+:[^/]+)/(\\d+)=>(\\w[^:]+:[^/]+)/(\\d+)$");
        Matcher m = p.matcher(mappingString);
        if (!mappingString.isEmpty() && m.matches()) {
            Block sourceBlock = Block.func_149684_b((String)m.group(1));
            int sourceMeta = Integer.parseInt(m.group(2));
            int itemCount = Integer.parseInt(m.group(3));
            String itemString = m.group(4);
            Item itemItem = GameRegistry.findItem((String)itemString.split(":", 2)[0], (String)itemString.split(":", 2)[1]);
            int itemMeta = Integer.parseInt(m.group(5));
            Block targetBlock = Block.func_149684_b((String)m.group(6));
            int targetMeta = Integer.parseInt(m.group(7));
            if (sourceBlock != null && itemItem != null && targetBlock != null) {
                ItemStack itemItemstack = new ItemStack(itemItem, itemCount, itemMeta);
                CustomMapping newMapping = new CustomMapping(sourceBlock, sourceMeta, itemItemstack, targetBlock, targetMeta);
                BetterBuildersWandsMod.logger.info(String.format("Added '%s' to mapping", mappingString));
                return newMapping;
            }
        }
        BetterBuildersWandsMod.logger.error(String.format("Error adding '%s' to mapping", mappingString));
        return null;
    }

    public CustomMapping getMapping(Block block, int meta) {
        for (CustomMapping mapping : this.mappings) {
            if (mapping.getLookBlock() != block || mapping.getMeta() != meta) continue;
            return mapping;
        }
        return null;
    }

    public void setMapping(CustomMapping newMapping) {
        for (int i = 0; i < this.mappings.size(); ++i) {
            CustomMapping current = this.mappings.get(i);
            if (current.getLookBlock() != newMapping.getLookBlock() || current.getMeta() != newMapping.getMeta()) continue;
            if (current.equals(newMapping)) {
                return;
            }
            this.mappings.set(i, newMapping);
            return;
        }
        this.mappings.add(newMapping);
    }
}

