/*
 * Decompiled with CFR 0.152.
 */
package portablejim.bbw.core.items;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import portablejim.bbw.BetterBuildersWandsMod;
import portablejim.bbw.basics.EnumFluidLock;
import portablejim.bbw.basics.EnumLock;
import portablejim.bbw.basics.Point3d;
import portablejim.bbw.core.WandWorker;
import portablejim.bbw.core.items.IWandItem;
import portablejim.bbw.core.wands.IWand;
import portablejim.bbw.shims.BasicPlayerShim;
import portablejim.bbw.shims.BasicWorldShim;
import portablejim.bbw.shims.CreativePlayerShim;

public abstract class ItemBasicWand
extends Item
implements IWandItem {
    public IWand wand;

    public ItemBasicWand() {
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.wand == null) {
            return EnumActionResult.FAIL;
        }
        if (itemstack == null) {
            BetterBuildersWandsMod.logger.error("BasicWand onItemUse itemstack empty");
            return EnumActionResult.FAIL;
        }
        if (!world.field_72995_K) {
            int numBlocks;
            LinkedList<Point3d> blocks;
            ArrayList<Point3d> placedBlocks;
            Point3d clickedPos;
            BasicWorldShim worldShim;
            WandWorker worker;
            ItemStack sourceItems;
            BasicPlayerShim playerShim = new BasicPlayerShim(player);
            if (player.field_71075_bZ.field_75098_d) {
                playerShim = new CreativePlayerShim(player);
            }
            if ((sourceItems = (worker = new WandWorker(this.wand, playerShim, worldShim = new BasicWorldShim(world))).getProperItemStack(worldShim, playerShim, clickedPos = new Point3d(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()))) != null && sourceItems.func_77973_b() instanceof ItemBlock && (placedBlocks = worker.placeBlocks(itemstack, blocks = worker.getBlockPositionList(clickedPos, side, numBlocks = Math.min(this.wand.getMaxBlocks(itemstack), playerShim.countItems(sourceItems)), this.getMode(itemstack), this.getFaceLock(itemstack), this.getFluidMode(itemstack)), clickedPos, sourceItems, side, hitX, hitY, hitZ)).size() > 0) {
                int[] placedIntArray = new int[placedBlocks.size() * 3];
                for (int i = 0; i < placedBlocks.size(); ++i) {
                    Point3d currentPoint = placedBlocks.get(i);
                    placedIntArray[i * 3] = currentPoint.x;
                    placedIntArray[i * 3 + 1] = currentPoint.y;
                    placedIntArray[i * 3 + 2] = currentPoint.z;
                }
                NBTTagCompound itemNBT = itemstack.func_77942_o() ? itemstack.func_77978_p() : new NBTTagCompound();
                NBTTagCompound bbwCompond = new NBTTagCompound();
                if (itemNBT.func_150297_b("bbw", 10)) {
                    bbwCompond = itemNBT.func_74775_l("bbw");
                }
                if (!bbwCompond.func_150297_b("mask", 2)) {
                    bbwCompond.func_74777_a("mask", (short)this.getDefaultMode().mask);
                }
                if (!bbwCompond.func_150297_b("fluidmask", 2)) {
                    bbwCompond.func_74777_a("fluidmask", (short)this.getDefaultFluidMode().mask);
                }
                bbwCompond.func_74783_a("lastPlaced", placedIntArray);
                bbwCompond.func_74778_a("lastBlock", ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)sourceItems.func_77973_b())).toString());
                bbwCompond.func_74768_a("lastBlockMeta", sourceItems.func_77952_i());
                bbwCompond.func_74768_a("lastPerBlock", sourceItems.field_77994_a);
                itemstack.func_77983_a("bbw", (NBTBase)bbwCompond);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List lines, boolean extraInfo) {
        EnumLock mode = this.getMode(itemstack);
        switch (mode) {
            case NORTHSOUTH: {
                lines.add(I18n.func_74838_a((String)"bbw.hover.mode.northsouth"));
                break;
            }
            case VERTICAL: {
                lines.add(I18n.func_74838_a((String)"bbw.hover.mode.vertical"));
                break;
            }
            case VERTICALEASTWEST: {
                lines.add(I18n.func_74838_a((String)"bbw.hover.mode.verticaleastwest"));
                break;
            }
            case EASTWEST: {
                lines.add(I18n.func_74838_a((String)"bbw.hover.mode.eastwest"));
                break;
            }
            case HORIZONTAL: {
                lines.add(I18n.func_74838_a((String)"bbw.hover.mode.horizontal"));
                break;
            }
            case VERTICALNORTHSOUTH: {
                lines.add(I18n.func_74838_a((String)"bbw.hover.mode.verticalnorthsouth"));
                break;
            }
            case NOLOCK: {
                lines.add(I18n.func_74838_a((String)"bbw.hover.mode.nolock"));
            }
        }
        EnumFluidLock fluidMode = this.getFluidMode(itemstack);
        switch (fluidMode) {
            case STOPAT: {
                lines.add(I18n.func_74838_a((String)"bbw.hover.fluidmode.stopat"));
                break;
            }
            case IGNORE: {
                lines.add(I18n.func_74838_a((String)"bbw.hover.fluidmode.ignore"));
            }
        }
        if (!itemstack.func_77984_f() || !itemstack.func_77951_h()) {
            lines.add(I18n.func_74837_a((String)"bbw.hover.maxblocks", (Object[])new Object[]{this.wand.getMaxBlocks(itemstack)}));
        }
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return false;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase playerIn) {
        stack.func_77972_a(2, playerIn);
        return true;
    }

    public boolean func_77644_a(ItemStack p_77644_1_, EntityLivingBase p_77644_2_, EntityLivingBase p_77644_3_) {
        p_77644_1_.func_77972_a(2, p_77644_3_);
        return true;
    }

    public void setMode(ItemStack item, EnumLock mode) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        if (item.func_77942_o()) {
            tagCompound = item.func_77978_p();
        }
        NBTTagCompound bbwCompond = new NBTTagCompound();
        if (tagCompound.func_150297_b("bbw", 10)) {
            bbwCompond = tagCompound.func_74775_l("bbw");
        }
        short shortMask = (short)(mode.mask & 7);
        bbwCompond.func_74777_a("mask", shortMask);
        tagCompound.func_74782_a("bbw", (NBTBase)bbwCompond);
        item.func_77982_d(tagCompound);
    }

    @Override
    public EnumLock getMode(ItemStack item) {
        NBTTagCompound itemBaseNBT;
        if (item != null && item.func_77973_b() != null && item.func_77973_b() instanceof IWandItem && (itemBaseNBT = item.func_77978_p()) != null && itemBaseNBT.func_150297_b("bbw", 10)) {
            NBTTagCompound itemNBT = itemBaseNBT.func_74775_l("bbw");
            int mask = itemNBT.func_150297_b("mask", 2) ? (int)itemNBT.func_74765_d("mask") : EnumLock.NOLOCK.mask;
            return EnumLock.fromMask(mask);
        }
        return this.getDefaultMode();
    }

    public void setFluidMode(ItemStack item, EnumFluidLock mode) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        if (item.func_77942_o()) {
            tagCompound = item.func_77978_p();
        }
        NBTTagCompound bbwCompond = new NBTTagCompound();
        if (tagCompound.func_150297_b("bbw", 10)) {
            bbwCompond = tagCompound.func_74775_l("bbw");
        }
        short shortMask = (short)(mode.mask & 7);
        bbwCompond.func_74777_a("fluidmask", shortMask);
        tagCompound.func_74782_a("bbw", (NBTBase)bbwCompond);
        item.func_77982_d(tagCompound);
    }

    @Override
    public EnumFluidLock getFluidMode(ItemStack item) {
        NBTTagCompound itemBaseNBT;
        if (item != null && item.func_77973_b() != null && item.func_77973_b() instanceof IWandItem && (itemBaseNBT = item.func_77978_p()) != null && itemBaseNBT.func_150297_b("bbw", 10)) {
            NBTTagCompound itemNBT = itemBaseNBT.func_74775_l("bbw");
            int mask = itemNBT.func_150297_b("fluidmask", 2) ? (int)itemNBT.func_74765_d("fluidmask") : EnumFluidLock.STOPAT.mask;
            return EnumFluidLock.fromMask(mask);
        }
        return this.getDefaultFluidMode();
    }

    @Override
    public IWand getWand() {
        return this.wand;
    }

    public EnumLock getDefaultMode() {
        return EnumLock.NOLOCK;
    }

    public EnumFluidLock getDefaultFluidMode() {
        return EnumFluidLock.STOPAT;
    }
}

