/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.gui.client.elements;

import com.valkyrieofnight.valkyrielib.client.SizableBox;
import com.valkyrieofnight.valkyrielib.client.TexUtils;
import com.valkyrieofnight.valkyrielib.gui.VLGuiResources;
import com.valkyrieofnight.valkyrielib.gui.client.VLGuiContainer;
import com.valkyrieofnight.valkyrielib.gui.client.elements.VLElement;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;

public class VLElementButton
extends VLElement {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected SizableBox buttonBox;
    protected SizableBox buttonBoxMouseOver;
    protected SizableBox buttonBoxDisabled;
    protected String buttonText;
    protected boolean enabled;
    protected int colorText;
    protected int colorTextMouseOver;
    protected int colorTextDisabled;

    public VLElementButton(String elementAddress, VLGuiContainer gui, int x, int y, int width, int height, String buttonText) {
        super(elementAddress, gui);
        this.init(x, y, width, height, buttonText);
    }

    public VLElementButton(VLGuiContainer gui, int x, int y, int width, int height, String buttonText) {
        super(gui);
        this.init(x, y, width, height, buttonText);
    }

    private void init(int x, int y, int width, int height, String buttonText) {
        this.buttonText = buttonText;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.buttonBox = VLGuiResources.BUTTON_STYLE_1;
        this.buttonBoxMouseOver = VLGuiResources.BUTTON_STYLE_2;
        this.buttonBoxDisabled = VLGuiResources.BUTTON_STYLE_3;
        this.enabled = true;
        this.colorText = 0xE0E0E0;
        this.colorTextDisabled = 0xA0A0A0;
        this.colorTextMouseOver = 0xFFFFA0;
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY, int guiLeft, int guiTop) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int col = this.colorTextMouseOver;
        if (this.enabled) {
            if (this.isMouseInBox(mouseX, mouseY, guiLeft + this.x, guiTop + this.y, guiLeft + this.x + this.width, guiTop + this.y + this.height)) {
                TexUtils.renderSizableBox(this.buttonBoxMouseOver, this.gui, guiLeft + this.x, guiTop + this.y, this.width, this.height);
                col = this.colorTextMouseOver;
            } else {
                TexUtils.renderSizableBox(this.buttonBox, this.gui, guiLeft + this.x, guiTop + this.y, this.width, this.height);
                col = this.colorText;
            }
        } else {
            TexUtils.renderSizableBox(this.buttonBoxDisabled, this.gui, guiLeft + this.x, guiTop + this.y, this.width, this.height);
            col = this.colorTextDisabled;
        }
        this.gui.func_73732_a(this.gui.getFontRenderer(), this.buttonText, guiLeft + this.x + this.width / 2, guiTop + this.y + (this.height - 8) / 2, col);
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
    }

    @Override
    public boolean onMouseClick(int guiLeft, int guiTop, int mouseX, int mouseY, int mouseButton) {
        return this.enabled && this.isMouseInBox(mouseX, mouseY, guiLeft + this.x, guiTop + this.y, guiLeft + this.x + this.width, guiTop + this.y + this.height);
    }

    @Override
    public void playPressSound(SoundHandler soundHandlerIn) {
        soundHandlerIn.func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public void setEnabled(boolean opt) {
        this.enabled = opt;
    }

    @Override
    public void updateScreen() {
    }

    @Override
    public boolean drawToolTipAt(int mouseX, int mouseY, int guiLeft, int guiTop) {
        return false;
    }
}

