/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.util;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class BlockOffset {
    private int x;
    private int y;
    private int z;

    public BlockOffset(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockOffset() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
    }

    public BlockPos getPosition(BlockPos centerPos) {
        return new BlockPos(centerPos.func_177958_n() + this.x, centerPos.func_177956_o() + this.y, centerPos.func_177952_p() + this.z);
    }

    public BlockPos getRotatedPosition(EnumFacing dir, BlockPos centerPos) {
        return new BlockPos(centerPos.func_177958_n() + this.getX(dir), centerPos.func_177956_o() + this.getY(dir), centerPos.func_177952_p() + this.getZ(dir));
    }

    private int getX(EnumFacing dir) {
        switch (dir) {
            case EAST: {
                return -this.z;
            }
            case SOUTH: {
                return -this.x;
            }
            case WEST: {
                return this.z;
            }
        }
        return this.x;
    }

    private int getY(EnumFacing dir) {
        return this.y;
    }

    private int getZ(EnumFacing dir) {
        switch (dir) {
            case EAST: {
                return this.x;
            }
            case SOUTH: {
                return -this.z;
            }
            case WEST: {
                return -this.x;
            }
        }
        return this.z;
    }

    private BlockOffset getOffset(EnumFacing dir) {
        return new BlockOffset(this.getX(dir), this.y, this.getZ(dir));
    }

    public boolean same(BlockOffset oth) {
        return this.x == oth.x && this.y == oth.y && this.z == oth.z;
    }

    public int getXOffset() {
        return this.x;
    }

    public int getYOffset() {
        return this.y;
    }

    public int getZOffset() {
        return this.z;
    }

    public String toString() {
        String str = "(";
        str = str + this.x + "," + this.y + "," + this.z + ")";
        return str;
    }
}

