/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.util.helpers;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class PlayerUtil {
    public static boolean doesPlayerExist(World world, UUID player) {
        if (player == null) {
            return false;
        }
        List players = world.field_73010_i;
        for (EntityPlayer entityPlayer : players) {
            if (entityPlayer.func_110124_au().compareTo(player) != 0) continue;
            return true;
        }
        return false;
    }

    public static EntityPlayer getPlayerFromWorld(World world, UUID player) {
        if (player == null) {
            return null;
        }
        List players = world.field_73010_i;
        for (EntityPlayer entityPlayer : players) {
            if (entityPlayer.func_110124_au().compareTo(player) != 0) continue;
            return entityPlayer;
        }
        return null;
    }

    public static NBTTagCompound proifleToNBT(GameProfile profile) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Name", profile.getName());
        UUID id = profile.getId();
        if (id != null) {
            tag.func_74772_a("UUIDL", id.getLeastSignificantBits());
            tag.func_74772_a("UUIDU", id.getMostSignificantBits());
        }
        return tag;
    }

    public static GameProfile profileFromNBT(NBTTagCompound tag) {
        String name = tag.func_74779_i("Name");
        UUID uuid = null;
        if (tag.func_74764_b("UUIDL")) {
            uuid = new UUID(tag.func_74763_f("UUIDU"), tag.func_74763_f("UUIDL"));
        } else if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return new GameProfile(uuid, name);
    }
}

