/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.block;

import com.zerofall.ezstorage.block.BlockStorageCore;
import com.zerofall.ezstorage.block.EZBlock;
import com.zerofall.ezstorage.tileentity.TileEntityStorageCore;
import com.zerofall.ezstorage.util.BlockRef;
import com.zerofall.ezstorage.util.EZStorageUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class StorageMultiblock
extends EZBlock {
    protected StorageMultiblock(String name, Material material) {
        super(name, material);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176206_d(worldIn, pos, state);
        this.attemptMultiblock(worldIn, pos);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        super.func_180652_a(worldIn, pos, explosionIn);
        this.attemptMultiblock(worldIn, pos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.attemptMultiblock(worldIn, pos);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        if (!worldIn.field_72995_K) {
            HashSet<TileEntityStorageCore> coreSet = new HashSet<TileEntityStorageCore>();
            BlockRef br = new BlockRef(this, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.findMultipleCores(br, worldIn, null, coreSet);
            if (coreSet.size() > 1) {
                return false;
            }
        }
        return super.func_176196_c(worldIn, pos);
    }

    public void attemptMultiblock(World world, BlockPos position) {
        BlockRef br;
        TileEntityStorageCore core;
        if (!world.field_72995_K && !(this instanceof BlockStorageCore) && (core = this.findCore(br = new BlockRef(this, position.func_177958_n(), position.func_177956_o(), position.func_177952_p()), world, null)) != null) {
            core.scanMultiblock();
        }
    }

    public TileEntityStorageCore findCore(BlockRef br, World world, Set<BlockRef> scanned) {
        if (scanned == null) {
            scanned = new HashSet<BlockRef>();
        }
        List<BlockRef> neighbors = EZStorageUtils.getNeighbors(br.pos.func_177958_n(), br.pos.func_177956_o(), br.pos.func_177952_p(), world);
        for (BlockRef blockRef : neighbors) {
            TileEntityStorageCore entity;
            if (!(blockRef.block instanceof StorageMultiblock)) continue;
            if (blockRef.block instanceof BlockStorageCore) {
                return (TileEntityStorageCore)world.func_175625_s(blockRef.pos);
            }
            if (!scanned.add(blockRef) || (entity = this.findCore(blockRef, world, scanned)) == null) continue;
            return entity;
        }
        return null;
    }

    public void findMultipleCores(BlockRef br, World world, Set<BlockRef> scanned, Set<TileEntityStorageCore> cores) {
        if (scanned == null) {
            scanned = new HashSet<BlockRef>();
        }
        List<BlockRef> neighbors = EZStorageUtils.getNeighbors(br.pos.func_177958_n(), br.pos.func_177956_o(), br.pos.func_177952_p(), world);
        for (BlockRef blockRef : neighbors) {
            if (!(blockRef.block instanceof StorageMultiblock)) continue;
            if (blockRef.block instanceof BlockStorageCore) {
                cores.add((TileEntityStorageCore)world.func_175625_s(blockRef.pos));
                continue;
            }
            if (!scanned.add(blockRef)) continue;
            this.findMultipleCores(blockRef, world, scanned, cores);
        }
    }
}

