/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.network;

import com.zerofall.ezstorage.EZStorage;
import com.zerofall.ezstorage.gui.server.ContainerStorageCoreCrafting;
import com.zerofall.ezstorage.util.JointList;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageCraftingSync
implements IMessage {
    private List<ItemStack> stackList;

    public MessageCraftingSync() {
    }

    public MessageCraftingSync(InventoryCrafting matrix) {
        this.stackList = new JointList<ItemStack>();
        for (int i = 0; i < matrix.func_70302_i_(); ++i) {
            this.stackList.add(matrix.func_70301_a(i));
        }
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        int count = tag.func_74762_e("count");
        NBTTagList list = tag.func_150295_c("items", 10);
        this.stackList = new JointList<ItemStack>();
        for (int i = 0; i < count; ++i) {
            NBTTagCompound item = list.func_150305_b(i);
            this.stackList.add(ItemStack.func_77949_a((NBTTagCompound)item));
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("count", this.stackList.size());
        NBTTagList list = new NBTTagList();
        for (ItemStack s : this.stackList) {
            NBTTagCompound nTag = new NBTTagCompound();
            if (s != null) {
                s.func_77955_b(nTag);
            }
            list.func_74742_a((NBTBase)nTag);
        }
        tag.func_74782_a("items", (NBTBase)list);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    implements IMessageHandler<MessageCraftingSync, IMessage> {
        public IMessage onMessage(MessageCraftingSync message, MessageContext ctx) {
            EntityPlayer player = EZStorage.proxy.getClientPlayer();
            if (player != null) {
                Minecraft.func_71410_x().func_152344_a(() -> this.handle(player, message));
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public void handle(EntityPlayer player, MessageCraftingSync message) {
            if (player.field_71070_bA != null && player.field_71070_bA instanceof ContainerStorageCoreCrafting) {
                InventoryCrafting craft = ((ContainerStorageCoreCrafting)player.field_71070_bA).craftMatrix;
                int i = 0;
                for (ItemStack s : message.stackList) {
                    craft.func_70299_a(i++, s);
                }
            }
        }
    }
}

