/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.network;

import com.zerofall.ezstorage.network.EZNetwork;
import com.zerofall.ezstorage.tileentity.TileEntitySecurityBox;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSecurePlayer
implements IMessage {
    private BlockPos pos;
    private TileEntitySecurityBox.SecurePlayer player;
    private int dimension;
    private boolean add;

    public MessageSecurePlayer() {
    }

    public MessageSecurePlayer(BlockPos pos, TileEntitySecurityBox.SecurePlayer player, int dimension, boolean add) {
        this.pos = pos;
        this.player = player;
        this.dimension = dimension;
        this.add = add;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.pos = BlockPos.func_177969_a((long)tag.func_74763_f("pos"));
        this.player = new TileEntitySecurityBox.SecurePlayer(tag.func_186857_a("secureID"), tag.func_74779_i("secureName"));
        this.dimension = tag.func_74762_e("dim");
        this.add = tag.func_74767_n("add");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("pos", this.pos.func_177986_g());
        tag.func_186854_a("secureID", this.player.id);
        tag.func_74778_a("secureName", this.player.name);
        tag.func_74768_a("dim", this.dimension);
        tag.func_74757_a("add", this.add);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    implements IMessageHandler<MessageSecurePlayer, IMessage> {
        public IMessage onMessage(MessageSecurePlayer m, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (player != null) {
                ((WorldServer)player.field_70170_p).func_152344_a(() -> this.handle(m));
            }
            return null;
        }

        public void handle(MessageSecurePlayer m) {
            PlayerList list = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
            for (EntityPlayerMP p : list.func_181057_v()) {
                if (p.field_71093_bK != m.dimension || !p.func_110124_au().toString().equals(((MessageSecurePlayer)m).player.id.toString())) continue;
                TileEntitySecurityBox tile = (TileEntitySecurityBox)p.field_70170_p.func_175625_s(m.pos);
                if (m.add) {
                    tile.addAllowedPlayer((EntityPlayer)p);
                } else {
                    tile.removeAllowedPlayer((EntityPlayer)p);
                }
                tile.func_70296_d();
                EZNetwork.sendSecureSyncMsg(p.field_70170_p, m.pos, tile.getAllowedPlayers());
            }
        }
    }
}

