/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.network;

import com.zerofall.ezstorage.tileentity.TileEntitySecurityBox;
import com.zerofall.ezstorage.util.JointList;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageSecureSync
implements IMessage {
    private BlockPos pos;
    private JointList<TileEntitySecurityBox.SecurePlayer> whitelist;

    public MessageSecureSync() {
    }

    public MessageSecureSync(BlockPos pos, List<TileEntitySecurityBox.SecurePlayer> list) {
        this.pos = pos;
        this.whitelist = new JointList<TileEntitySecurityBox.SecurePlayer>().join((Iterable<TileEntitySecurityBox.SecurePlayer>)list);
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.pos = BlockPos.func_177969_a((long)tag.func_74763_f("pos"));
        int count = tag.func_74762_e("whitelistCount");
        this.whitelist = new JointList();
        for (int i = 0; i < count; ++i) {
            this.whitelist.join((TileEntitySecurityBox.SecurePlayer[])new TileEntitySecurityBox.SecurePlayer[]{new TileEntitySecurityBox.SecurePlayer(tag.func_186857_a("whitelist" + i + "_id"), tag.func_74779_i("whitelist" + i + "_name"))});
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("pos", this.pos.func_177986_g());
        tag.func_74768_a("whitelistCount", this.whitelist.size());
        int i = 0;
        for (TileEntitySecurityBox.SecurePlayer p : this.whitelist) {
            tag.func_186854_a("whitelist" + i + "_id", p.id);
            tag.func_74778_a("whitelist" + i++ + "_name", p.name);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    implements IMessageHandler<MessageSecureSync, IMessage> {
        public IMessage onMessage(MessageSecureSync m, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> this.handle(m));
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public void handle(MessageSecureSync m) {
            try {
                TileEntitySecurityBox tile = (TileEntitySecurityBox)Minecraft.func_71410_x().field_71441_e.func_175625_s(m.pos);
                tile.setAllowedPlayers(m.whitelist);
            }
            catch (Exception e) {
                System.out.println("Message exception caught: " + e.getMessage());
            }
        }
    }
}

