/*
 * Decompiled with CFR 0.152.
 */
package com.zerofall.ezstorage.tileentity;

import com.zerofall.ezstorage.config.EZConfig;
import com.zerofall.ezstorage.tileentity.TileEntityBase;
import com.zerofall.ezstorage.util.JointList;
import com.zerofall.ezstorage.util.SecurityOverrideHelper;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntitySecurityBox
extends TileEntityBase {
    private JointList<SecurePlayer> allowedPlayers = new JointList();
    private boolean sendOpNotification = false;
    private EntityPlayerMP op = null;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.sendOpNotification && this.op != null) {
            SecurityOverrideHelper.sendOpNotification(this.op, this.allowedPlayers);
            this.sendOpNotification = false;
        }
    }

    public List<SecurePlayer> getAllowedPlayers() {
        return this.allowedPlayers;
    }

    public void setAllowedPlayers(JointList<SecurePlayer> players) {
        this.allowedPlayers = players;
    }

    public int getAllowedPlayerCount() {
        return this.allowedPlayers.size();
    }

    public boolean isPlayerAllowed(EntityPlayer p) {
        if (this.getAllowedPlayerCount() == 0) {
            return true;
        }
        for (SecurePlayer sp : this.allowedPlayers) {
            if (!sp.id.toString().equals(p.getPersistentID().toString())) continue;
            return true;
        }
        if (EZConfig.enableOpOverride && !p.field_70170_p.field_72995_K && p.field_71075_bZ.field_75098_d && SecurityOverrideHelper.isPlayerOpLv2((EntityPlayerMP)p)) {
            this.op = (EntityPlayerMP)p;
            this.sendOpNotification = true;
            return true;
        }
        return false;
    }

    public boolean isOwner(EntityPlayer p) {
        if (this.getAllowedPlayerCount() == 0) {
            return false;
        }
        return ((SecurePlayer)this.allowedPlayers.get((int)0)).id.toString().equals(p.getPersistentID().toString());
    }

    public boolean addAllowedPlayer(EntityPlayer p) {
        return this.allowedPlayers.add(new SecurePlayer(p));
    }

    public boolean removeAllowedPlayer(EntityPlayer p) {
        Iterator i = this.allowedPlayers.iterator();
        while (i.hasNext()) {
            SecurePlayer n = (SecurePlayer)i.next();
            if (!n.id.toString().equals(p.getPersistentID().toString())) continue;
            i.remove();
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound writeDataToNBT(NBTTagCompound tag) {
        int i = 0;
        tag.func_74768_a("allowedPlayerCount", this.getAllowedPlayerCount());
        for (SecurePlayer p : this.allowedPlayers) {
            tag.func_186854_a("allowedPlayer" + i + "_id", p.id);
            tag.func_74778_a("allowedPlayer" + i++ + "_name", p.name);
        }
        return tag;
    }

    @Override
    public void readDataFromNBT(NBTTagCompound tag) {
        this.allowedPlayers = new JointList();
        int count = tag.func_74762_e("allowedPlayerCount");
        for (int i = 0; i < count; ++i) {
            this.allowedPlayers.add(new SecurePlayer(tag.func_186857_a("allowedPlayer" + i + "_id"), tag.func_74779_i("allowedPlayer" + i + "_name")));
        }
    }

    public static class SecurePlayer {
        public UUID id;
        public String name;

        public SecurePlayer(EntityPlayer player) {
            this(player.getPersistentID(), player.func_70005_c_());
        }

        public SecurePlayer(UUID id, String name) {
            this.id = id;
            this.name = name;
        }

        public String toString() {
            return this.id + "=" + this.name;
        }
    }
}

