/*
 * Decompiled with CFR 0.152.
 */
package lumien.bloodmoon.asm;

import lumien.bloodmoon.asm.MCPNames;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer {
    Logger logger = LogManager.getLogger((String)"Bloodmoon");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.client.renderer.RenderGlobal")) {
            return this.patchRenderGlobal(basicClass);
        }
        if (transformedName.equals("net.minecraft.client.renderer.EntityRenderer")) {
            return this.patchEntityRendererClass(basicClass);
        }
        return basicClass;
    }

    private byte[] patchRenderGlobal(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found Render Global Class: " + classNode.name);
        String renderSkyName = MCPNames.method("func_174976_a");
        MethodNode renderSky = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(renderSkyName) || !mn.desc.equals("(FI)V")) continue;
            renderSky = mn;
            break;
        }
        if (renderSky != null) {
            this.logger.log(Level.DEBUG, " - Found renderSky");
            for (int i = 0; i < renderSky.instructions.size(); ++i) {
                InsnList toInsert;
                AbstractInsnNode ain = renderSky.instructions.get(i);
                if (ain instanceof FieldInsnNode) {
                    FieldInsnNode fin = (FieldInsnNode)ain;
                    if (!fin.name.equals(MCPNames.field("field_110927_h"))) continue;
                    this.logger.log(Level.DEBUG, " - Found moonColor");
                    toInsert = new InsnList();
                    toInsert.add((AbstractInsnNode)new FieldInsnNode(178, "lumien/bloodmoon/client/ClientBloodmoonHandler", "INSTANCE", "Llumien/bloodmoon/client/ClientBloodmoonHandler;"));
                    toInsert.add((AbstractInsnNode)new MethodInsnNode(182, "lumien/bloodmoon/client/ClientBloodmoonHandler", "moonColorHook", "()V", false));
                    renderSky.instructions.insert((AbstractInsnNode)fin, toInsert);
                    i += 2;
                    continue;
                }
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.name.equals(MCPNames.method("func_72833_a"))) continue;
                this.logger.log(Level.DEBUG, " - Found skyColor");
                toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new InsnNode(89));
                toInsert.add((AbstractInsnNode)new FieldInsnNode(178, "lumien/bloodmoon/client/ClientBloodmoonHandler", "INSTANCE", "Llumien/bloodmoon/client/ClientBloodmoonHandler;"));
                toInsert.add((AbstractInsnNode)new InsnNode(95));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(182, "lumien/bloodmoon/client/ClientBloodmoonHandler", "skyColorHook", "(Lnet/minecraft/util/math/Vec3d;)V", false));
                renderSky.instructions.insert((AbstractInsnNode)min, toInsert);
                i += 4;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchEntityRendererClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found EntityRenderer Class: " + classNode.name);
        String methodName = MCPNames.method("func_78472_g");
        MethodNode updateLightmap = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(methodName)) continue;
            updateLightmap = mn;
        }
        if (updateLightmap != null) {
            this.logger.log(Level.DEBUG, " - Found updateLightmap");
            boolean insertedHook = false;
            for (int i = 0; i < updateLightmap.instructions.size(); ++i) {
                VarInsnNode iin;
                AbstractInsnNode an = updateLightmap.instructions.get(i);
                if (!(an instanceof VarInsnNode) || insertedHook || (iin = (VarInsnNode)an).getOpcode() != 54 || iin.var != 22) continue;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new FieldInsnNode(178, "lumien/bloodmoon/client/ClientBloodmoonHandler", "INSTANCE", "Llumien/bloodmoon/client/ClientBloodmoonHandler;"));
                toInsert.add((AbstractInsnNode)new VarInsnNode(21, 5));
                toInsert.add((AbstractInsnNode)new VarInsnNode(21, 20));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(182, "lumien/bloodmoon/client/ClientBloodmoonHandler", "manipulateRed", "(II)I", false));
                toInsert.add((AbstractInsnNode)new VarInsnNode(54, 20));
                toInsert.add((AbstractInsnNode)new FieldInsnNode(178, "lumien/bloodmoon/client/ClientBloodmoonHandler", "INSTANCE", "Llumien/bloodmoon/client/ClientBloodmoonHandler;"));
                toInsert.add((AbstractInsnNode)new VarInsnNode(21, 5));
                toInsert.add((AbstractInsnNode)new VarInsnNode(21, 21));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(182, "lumien/bloodmoon/client/ClientBloodmoonHandler", "manipulateGreen", "(II)I", false));
                toInsert.add((AbstractInsnNode)new VarInsnNode(54, 21));
                toInsert.add((AbstractInsnNode)new FieldInsnNode(178, "lumien/bloodmoon/client/ClientBloodmoonHandler", "INSTANCE", "Llumien/bloodmoon/client/ClientBloodmoonHandler;"));
                toInsert.add((AbstractInsnNode)new VarInsnNode(21, 5));
                toInsert.add((AbstractInsnNode)new VarInsnNode(21, 22));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(182, "lumien/bloodmoon/client/ClientBloodmoonHandler", "manipulateBlue", "(II)I", false));
                toInsert.add((AbstractInsnNode)new VarInsnNode(54, 22));
                updateLightmap.instructions.insert((AbstractInsnNode)iin, toInsert);
                insertedHook = true;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchDummyClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.INFO, "Found Dummy Class: " + classNode.name);
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

