/*
 * Decompiled with CFR 0.152.
 */
package lumien.bloodmoon.client;

import lumien.bloodmoon.config.BloodmoonConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class ClientBloodmoonHandler {
    public static ClientBloodmoonHandler INSTANCE = new ClientBloodmoonHandler();
    boolean bloodmoonActive = false;
    final float sinMax = 2.6179937E-4f;
    float lightSub;
    public float fogRemove;
    float skyColorAdd;
    float moonColorRed;
    float d = 6.666667E-5f;
    int difTime = 0;
    double sin;

    public boolean isBloodmoonActive() {
        return this.bloodmoonActive;
    }

    public void setBloodmoon(boolean active) {
        this.bloodmoonActive = active;
    }

    public void moonColorHook() {
        if (this.isBloodmoonActive() && BloodmoonConfig.RED_MOON) {
            GL11.glColor3f((float)0.8f, (float)0.0f, (float)0.0f);
        }
    }

    public void skyColorHook(Vec3d color) {
        if (this.isBloodmoonActive() && BloodmoonConfig.RED_SKY) {
            color.field_72450_a += (double)ClientBloodmoonHandler.INSTANCE.skyColorAdd;
        }
    }

    public int manipulateRed(int position, int originalValue) {
        return originalValue;
    }

    public int manipulateGreen(int position, int originalValue) {
        int height;
        if (this.isBloodmoonActive() && BloodmoonConfig.RED_LIGHT && (height = position / 16) < 16) {
            float mod = 0.0625f * (float)height;
            originalValue = (int)((double)originalValue - (double)(mod * this.lightSub) * (this.sin / 2.0 + 1.0));
            return Math.max(originalValue, 0);
        }
        return originalValue;
    }

    public int manipulateBlue(int position, int originalValue) {
        int height;
        if (this.isBloodmoonActive() && BloodmoonConfig.RED_LIGHT && (height = position / 16) < 16) {
            float mod = 0.0625f * (float)height;
            originalValue = (int)((float)originalValue - mod * this.lightSub * 2.3f);
            return Math.max(originalValue, 0);
        }
        return originalValue;
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (this.isBloodmoonActive()) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (world != null && player != null) {
                float difTime = (int)(world.func_72820_D() % 24000L) - 12000;
                this.sin = Math.sin(difTime * 2.6179937E-4f);
                this.lightSub = (float)(this.sin * 150.0);
                this.skyColorAdd = (float)(this.sin * (double)0.1f);
                this.moonColorRed = (float)(this.sin * (double)0.7f);
                this.fogRemove = (float)(this.sin * (double)this.d * 6000.0);
                if (world.field_73011_w.getDimension() != 0) {
                    this.bloodmoonActive = false;
                }
            } else if (this.bloodmoonActive) {
                this.bloodmoonActive = false;
            }
        }
    }
}

