/*
 * Decompiled with CFR 0.152.
 */
package lumien.bloodmoon.config;

import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class BloodmoonConfig {
    public static Configuration cfg;
    Property RED_MOON_PROPERTY;
    public static boolean RED_MOON;
    Property RED_SKY_PROPERTY;
    public static boolean RED_SKY;
    Property RED_LIGHT_PROPERTY;
    public static boolean RED_LIGHT;
    Property BLACK_FOG_PROPERTY;
    public static boolean BLACK_FOG;
    Property CHANCE_PROPERTY;
    public static double CHANCE;
    Property SPAWN_SPEED_PROPERTY;
    public static int SPAWN_SPEED;
    Property SPAWN_LIMIT_MULT_PROPERTY;
    public static int SPAWN_LIMIT_MULT;
    Property SPAWN_RANGE_PROPERTY;
    public static int SPAWN_RANGE;
    Property SPAWN_DISTANCE_PROPERTY;
    public static int SPAWN_DISTANCE;
    Property NO_SLEEP_PROPERTY;
    public static boolean NO_SLEEP;
    Property VANISH_PROPERTY;
    public static boolean VANISH;
    Property RESPECT_GAMERULE_PROPERTY;
    public static boolean RESPECT_GAMERULE;
    Property SEND_MESSAGE_PROPERTY;
    public static boolean SEND_MESSAGE;

    public void preInit(FMLPreInitializationEvent event) {
        cfg = new Configuration(event.getSuggestedConfigurationFile());
        cfg.load();
        this.CHANCE_PROPERTY = cfg.get("General", "Chance", 0.05, "The chance of a bloodmoon occuring (0=Never;1=Every night;0.05=5% of all nights)");
        this.SPAWN_SPEED_PROPERTY = cfg.get("General", "SpawnSpeed", 4, "How much faster enemys spawn on a bloodmoon (0=Vanilla)");
        this.SPAWN_LIMIT_MULT_PROPERTY = cfg.get("General", "SpawnLimitMultiplier", 4, "With which number should the default entity limit be multiplicated on a blood moon");
        this.SPAWN_RANGE_PROPERTY = cfg.get("General", "SpawnRange", 2, "How close can enemys spawn next to the player on a bloodmoon in blocks? (Vanilla=24)");
        this.SPAWN_DISTANCE_PROPERTY = cfg.get("General", "WorldSpawnDistance", 24, "How close can enemys spawn next to the World Spawn (Vanilla=24)");
        this.NO_SLEEP_PROPERTY = cfg.get("General", "NoSleep", true, "Whether players are not able to sleep on a bloodmoon");
        this.VANISH_PROPERTY = cfg.get("General", "Vanish", false, "Whether monsters spawned by a bloodmoon should die at dawn");
        this.RESPECT_GAMERULE_PROPERTY = cfg.get("General", "RespectGamerule", true, "Whether bloodmoons should respect the doMobSpawning gamerule");
        this.SEND_MESSAGE_PROPERTY = cfg.get("General", "SendMessage", true, "Whether all players in the overworld should receive a message when the bloodmoon starts");
        this.RED_MOON_PROPERTY = cfg.get("Visuals", "RedMoon", true);
        this.RED_SKY_PROPERTY = cfg.get("Visuals", "RedSky", true);
        this.RED_LIGHT_PROPERTY = cfg.get("Visuals", "RedLight", true);
        this.BLACK_FOG_PROPERTY = cfg.get("Visuals", "BlackFog", true);
        this.syncConfig();
    }

    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("Bloodmoon")) {
            this.syncConfig();
        }
    }

    public void syncConfig() {
        CHANCE = this.CHANCE_PROPERTY.getDouble();
        SPAWN_SPEED = this.SPAWN_SPEED_PROPERTY.getInt();
        SPAWN_LIMIT_MULT = this.SPAWN_LIMIT_MULT_PROPERTY.getInt();
        SPAWN_RANGE = this.SPAWN_RANGE_PROPERTY.getInt();
        SPAWN_DISTANCE = this.SPAWN_DISTANCE_PROPERTY.getInt();
        NO_SLEEP = this.NO_SLEEP_PROPERTY.getBoolean();
        VANISH = this.VANISH_PROPERTY.getBoolean();
        RESPECT_GAMERULE = this.RESPECT_GAMERULE_PROPERTY.getBoolean();
        SEND_MESSAGE = this.SEND_MESSAGE_PROPERTY.getBoolean();
        RED_MOON = this.RED_MOON_PROPERTY.getBoolean();
        RED_SKY = this.RED_SKY_PROPERTY.getBoolean();
        RED_LIGHT = this.RED_LIGHT_PROPERTY.getBoolean();
        BLACK_FOG = this.BLACK_FOG_PROPERTY.getBoolean();
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    static {
        RED_MOON = true;
        RED_SKY = true;
        RED_LIGHT = true;
        BLACK_FOG = true;
    }
}

