/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.blocks.ConnectionBlockType;
import vswe.stevesfactory.components.CheckBox;
import vswe.stevesfactory.components.CheckBoxList;
import vswe.stevesfactory.components.ComponentMenu;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.interfaces.ContainerManager;
import vswe.stevesfactory.interfaces.GuiManager;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.PacketHandler;

public class ComponentMenuContainerTypes
extends ComponentMenu {
    private static final int CHECK_BOX_X = 5;
    private static final int CHECK_BOX_Y = 5;
    private static final int CHECK_BOX_SPACING_X = 55;
    private static final int CHECK_BOX_SPACING_Y = 12;
    private List<ConnectionBlockType> types = new ArrayList<ConnectionBlockType>();
    private boolean[] checked;
    private CheckBoxList checkBoxes;
    private static final String NBT_CHECKED = "Checked";

    public ComponentMenuContainerTypes(FlowComponent parent) {
        super(parent);
        int i;
        for (ConnectionBlockType connectionBlockType : ConnectionBlockType.values()) {
            if (connectionBlockType.isGroup()) continue;
            this.types.add(connectionBlockType);
        }
        this.checked = new boolean[this.types.size()];
        for (i = 0; i < this.checked.length; ++i) {
            this.checked[i] = true;
        }
        this.checkBoxes = new CheckBoxList();
        for (i = 0; i < this.types.size(); ++i) {
            final int id = i;
            int x = i % 2;
            int y = i / 2;
            this.checkBoxes.addCheckBox(new CheckBox(this.types.get(i).getName(), 5 + 55 * x, 5 + 12 * y){

                @Override
                public void setValue(boolean val) {
                    ((ComponentMenuContainerTypes)ComponentMenuContainerTypes.this).checked[id] = val;
                }

                @Override
                public boolean getValue() {
                    return ComponentMenuContainerTypes.this.checked[id];
                }

                @Override
                public void onUpdate() {
                    DataWriter dw = ComponentMenuContainerTypes.this.getWriterForServerComponentPacket();
                    dw.writeData(id, DataBitHelper.CONTAINER_TYPE);
                    dw.writeBoolean(ComponentMenuContainerTypes.this.checked[id]);
                    PacketHandler.sendDataToServer(dw);
                }
            });
        }
    }

    @Override
    public String getName() {
        return Localization.CONTAINER_TYPE_MENU.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        this.checkBoxes.draw(gui, mX, mY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        this.checkBoxes.onClick(mX, mY);
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void writeData(DataWriter dw) {
        for (boolean b : this.checked) {
            dw.writeBoolean(b);
        }
    }

    @Override
    public void readData(DataReader dr) {
        for (int i = 0; i < this.checked.length; ++i) {
            this.checked[i] = dr.readBoolean();
        }
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
        ComponentMenuContainerTypes menuTypes = (ComponentMenuContainerTypes)menu;
        for (int i = 0; i < this.checked.length; ++i) {
            this.checked[i] = menuTypes.checked[i];
        }
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        ComponentMenuContainerTypes newDataTypes = (ComponentMenuContainerTypes)newData;
        for (int i = 0; i < this.checked.length; ++i) {
            if (newDataTypes.checked[i] == this.checked[i]) continue;
            this.checked[i] = newDataTypes.checked[i];
            DataWriter dw = this.getWriterForClientComponentPacket(container);
            dw.writeData(i, DataBitHelper.CONTAINER_TYPE);
            dw.writeBoolean(this.checked[i]);
            PacketHandler.sendDataToListeningClients(container, dw);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        byte data = nbtTagCompound.func_74771_c(NBT_CHECKED);
        for (int i = 0; i < this.checked.length; ++i) {
            this.checked[i] = (data >> i & 1) != 0;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        byte data = 0;
        for (int i = 0; i < this.checked.length; ++i) {
            if (!this.checked[i]) continue;
            data = (byte)(data | 1 << i);
        }
        nbtTagCompound.func_74774_a(NBT_CHECKED, data);
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        int id = dr.readData(DataBitHelper.CONTAINER_TYPE);
        this.checked[id] = dr.readBoolean();
    }

    public boolean[] getChecked() {
        return this.checked;
    }

    public List<ConnectionBlockType> getTypes() {
        return this.types;
    }

    public EnumSet<ConnectionBlockType> getValidTypes() {
        EnumSet<ConnectionBlockType> types = EnumSet.noneOf(ConnectionBlockType.class);
        for (int i = 0; i < this.getTypes().size(); ++i) {
            if (!this.getChecked()[i]) continue;
            types.add(this.getTypes().get(i));
        }
        return types;
    }
}

