/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.proxy;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import vswe.stevesfactory.blocks.ModBlocks;
import vswe.stevesfactory.blocks.client.ModelLoader;
import vswe.stevesfactory.proxy.CommonProxy;
import vswe.stevesfactory.settings.Settings;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        Settings.load();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoader());
        ClientProxy.addVariantNames((Block)ModBlocks.blockCableRelay, "cable_relay", "cable_relay_advanced");
        ClientProxy.addVariantNames((Block)ModBlocks.blockCableIntake, "cable_valve", "cable_valve_instant");
        ClientProxy.addVariantNames((Block)ModBlocks.blockCableCluster, "cable_cluster", "cable_cluster_advanced");
        ClientProxy.addVariantNames((Block)ModBlocks.blockCableCamouflage, "cable_camouflage", "cable_camouflage_inside", "cable_camouflage_transform");
        ClientProxy.registerBlockModel((Block)ModBlocks.blockManager);
        ClientProxy.registerBlockModel(ModBlocks.blockCable);
        ClientProxy.registerBlockModel((Block)ModBlocks.blockCableOutput);
        ClientProxy.registerBlockModel((Block)ModBlocks.blockCableInput);
        ClientProxy.registerBlockModel((Block)ModBlocks.blockCableCreative);
        ClientProxy.registerBlockModel((Block)ModBlocks.blockCableBUD);
        ClientProxy.registerBlockModel((Block)ModBlocks.blockCableBreaker);
        ClientProxy.registerBlockModel((Block)ModBlocks.blockCableSign);
        ClientProxy.registerBlockModelForVariant((Block)ModBlocks.blockCableRelay, 0, "cable_relay");
        ClientProxy.registerBlockModelForVariant((Block)ModBlocks.blockCableRelay, 8, "cable_relay_advanced");
        ClientProxy.registerBlockModelForVariant((Block)ModBlocks.blockCableIntake, 0, "cable_valve");
        ClientProxy.registerBlockModelForVariant((Block)ModBlocks.blockCableIntake, 8, "cable_valve_instant");
        ClientProxy.registerBlockModelForVariant((Block)ModBlocks.blockCableCluster, 0, "cable_cluster");
        ClientProxy.registerBlockModelForVariant((Block)ModBlocks.blockCableCluster, 8, "cable_cluster_advanced");
        ClientProxy.registerBlockModelForVariant((Block)ModBlocks.blockCableCamouflage, 0, "cable_camouflage");
        ClientProxy.registerBlockModelForVariant((Block)ModBlocks.blockCableCamouflage, 1, "cable_camouflage_inside");
        ClientProxy.registerBlockModelForVariant((Block)ModBlocks.blockCableCamouflage, 2, "cable_camouflage_transform");
    }

    private static void addVariantNames(Block block, String ... names) {
        ResourceLocation[] locations = new ResourceLocation[names.length];
        for (int i = 0; i < names.length; ++i) {
            locations[i] = new ResourceLocation(ClientProxy.getResource(names[i]));
        }
        if (block != null) {
            ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)block), (ResourceLocation[])locations);
        }
    }

    private static void registerBlockModelForVariant(Block base, int meta, String variant) {
        ClientProxy.registerBlockModel(base, meta, ClientProxy.getResource(variant));
    }

    private static void registerBlockModel(Block block) {
        ResourceLocation resourceLocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
        ClientProxy.registerBlockModel(block, 0, resourceLocation.toString());
    }

    private static void registerBlockModel(Block block, int meta, String modelName) {
        ClientProxy.registerItemModel(Item.func_150898_a((Block)block), meta, modelName);
    }

    private static void registerItemModel(Item item, int meta, String resourcePath) {
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(resourcePath, "inventory");
        net.minecraftforge.client.model.ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)modelResourceLocation);
    }

    public static String getResource(String resource) {
        return "StevesFactoryManager".toLowerCase() + ":" + resource;
    }
}

