/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import de.maxhenkel.gravestone.BlockGraveStone;
import de.maxhenkel.gravestone.BlockNotFoundException;
import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.MBlocks;
import de.maxhenkel.gravestone.MItems;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.TileEntityGraveStone;
import de.maxhenkel.gravestone.Tools;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DeathPosition {
    public static final String REPLACEABLE_BLOCKS = "replaceable_blocks";
    public static final String[] DEFAULT_BLOCKS = new String[]{"minecraft:tallgrass", "minecraft:water", "minecraft:lava", "minecraft:yellow_flower", "minecraft:red_flower", "minecraft:double_plant", "minecraft:sapling", "minecraft:brown_mushroom", "minecraft:red_mushroom", "minecraft:torch", "minecraft:snow_layer", "minecraft:vine", "minecraft:deadbush", "minecraft:reeds", "minecraft:fire"};
    private EntityLivingBase entity;
    private World world;
    private BlockPos deathPosition;
    private BlockPos gravePosition;
    private static ArrayList<Block> replaceableBlocks;
    private List<ItemStack> drops;
    private long time;

    public DeathPosition(EntityLivingBase entity) {
        this.entity = entity;
        this.world = entity.field_70170_p;
        this.gravePosition = this.deathPosition = entity.func_180425_c();
        this.drops = new ArrayList<ItemStack>();
        this.time = System.currentTimeMillis();
        if (replaceableBlocks == null) {
            try {
                String[] blocks = Main.getInstance().getConfig().getStringArray(REPLACEABLE_BLOCKS, DEFAULT_BLOCKS);
                replaceableBlocks = DeathPosition.getBlocks(blocks);
                if (blocks == null) {
                    replaceableBlocks = DeathPosition.getBlocks(DEFAULT_BLOCKS);
                }
            }
            catch (Exception e) {
                replaceableBlocks = new ArrayList();
            }
        }
    }

    public boolean placeGraveStone(List<EntityItem> drops) {
        try {
            this.gravePosition = this.getGraveStoneLocation();
        }
        catch (BlockNotFoundException e) {
            this.gravePosition = this.deathPosition;
            return false;
        }
        try {
            this.world.func_175656_a(this.gravePosition, MBlocks.GRAVESTONE.func_176223_P().func_177226_a((IProperty)BlockGraveStone.FACING, (Comparable)this.entity.func_174811_aO().func_176734_d()));
            if (this.isReplaceable(this.gravePosition.func_177977_b())) {
                this.world.func_175656_a(this.gravePosition.func_177977_b(), Blocks.field_150346_d.func_176223_P());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        TileEntity tileentity = this.world.func_175625_s(this.gravePosition);
        if (tileentity == null || !(tileentity instanceof TileEntityGraveStone)) {
            return false;
        }
        try {
            TileEntityGraveStone graveTileEntity = (TileEntityGraveStone)tileentity;
            graveTileEntity.setPlayerName(this.entity.func_70005_c_());
            graveTileEntity.setPlayerUUID(this.entity.func_110124_au().toString());
            graveTileEntity.setDeathTime(this.time);
            graveTileEntity.setRenderHead(this.entity instanceof EntityPlayer);
            this.addItems(graveTileEntity, drops);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private void addItems(TileEntityGraveStone graveStone, List<EntityItem> items) {
        try {
            for (int i = 0; i < items.size(); ++i) {
                try {
                    EntityItem item = items.get(i);
                    ItemStack stack = item.func_92059_d();
                    this.drops.add(stack);
                    graveStone.func_70299_a(i, stack);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BlockPos getGraveStoneLocation() throws BlockNotFoundException {
        BlockPos location = new BlockPos(this.deathPosition.func_177958_n(), this.deathPosition.func_177956_o(), this.deathPosition.func_177952_p());
        if (location.func_177956_o() < 1) {
            location = new BlockPos(location.func_177958_n(), 1, location.func_177952_p());
        }
        for (int i = 1; i < this.entity.field_70170_p.func_72800_K(); ++i) {
            if (this.isReplaceable(location)) {
                return location;
            }
            if (location.func_177956_o() >= this.entity.field_70170_p.func_72800_K()) break;
            location = location.func_177982_a(0, 1, 0);
        }
        throw new BlockNotFoundException("No free Block above death Location");
    }

    private boolean isReplaceable(BlockPos pos) {
        Block b = this.world.func_180495_p(pos).func_177230_c();
        if (b.func_149739_a().equals(Blocks.field_150350_a.func_149739_a())) {
            return true;
        }
        for (Block replaceableBlock : replaceableBlocks) {
            if (!b.func_149739_a().equals(replaceableBlock.func_149739_a())) continue;
            return true;
        }
        return false;
    }

    public static Block getBlock(String name) {
        try {
            String[] split = name.split(":");
            if (split.length == 2) {
                Block b = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(split[0], split[1]));
                if (b.equals(Blocks.field_150350_a)) {
                    return null;
                }
                return b;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ArrayList<Block> getBlocks(String[] names) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (String s : names) {
            Block b = DeathPosition.getBlock(s);
            if (b == null) continue;
            blocks.add(b);
        }
        return blocks;
    }

    public void givePlayerNote() {
        ItemStack stack;
        if (!(this.entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)this.entity;
        DeathInfo.ItemInfo[] items = new DeathInfo.ItemInfo[this.drops.size()];
        for (int i = 0; i < this.drops.size(); ++i) {
            stack = this.drops.get(i);
            if (stack == null) continue;
            items[i] = new DeathInfo.ItemInfo(Tools.getStringFromItem(stack.func_77973_b()), stack.field_77994_a);
        }
        DeathInfo info = new DeathInfo(this.gravePosition, this.entity.field_71093_bK, items, this.entity.func_70005_c_(), this.time);
        stack = new ItemStack(MItems.DEATH_INFO);
        info.addToItemStack(stack);
        player.field_71071_by.func_70441_a(stack);
    }

    public static void givePlayerNote(EntityPlayer player) {
        DeathInfo info = new DeathInfo(player.func_180425_c(), player.field_71093_bK, new DeathInfo.ItemInfo[0], player.getDisplayNameString(), System.currentTimeMillis());
        ItemStack stack = new ItemStack(MItems.DEATH_INFO);
        info.addToItemStack(stack);
        player.field_71071_by.func_70441_a(stack);
    }

    public EntityLivingBase getEntity() {
        return this.entity;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getDeathPosition() {
        return this.deathPosition;
    }

    public static ArrayList<Block> getReplaceableBlocks() {
        return replaceableBlocks;
    }

    public List<ItemStack> getDrops() {
        return this.drops;
    }

    public long getTime() {
        return this.time;
    }

    public BlockPos getGravePosition() {
        return this.gravePosition;
    }
}

