/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.DeathPosition;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.Tools;
import de.maxhenkel.gravestone.UpdateChecker;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Events {
    public static final String KEY_CHECK_UPDATES = "check_updates";
    public static final String KEY_DEATH_NOTE = "enable_death_note";
    public static final String KEY_LIVING_GRAVES = "enable_living_entity_graves";
    private boolean checkUpdates = Main.getInstance().getConfig().getBoolean("check_updates", true);
    private boolean updateShown = false;
    private boolean givePlayerNote = Main.getInstance().getConfig().getBoolean("enable_death_note", true);
    private boolean livingGraves = Main.getInstance().getConfig().getBoolean("enable_living_entity_graves", false);

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerCloneLast(PlayerEvent.Clone event) {
        if (!this.givePlayerNote) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!event.isWasDeath()) {
            return;
        }
        if (Tools.keepInventory(event.getEntityPlayer())) {
            return;
        }
        for (ItemStack stack : event.getOriginal().field_71071_by.field_70462_a) {
            if (!DeathInfo.isDeathInfoItem(stack)) continue;
            event.getEntityPlayer().field_71071_by.func_70441_a(stack);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDeath(LivingDropsEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event.getEntity() instanceof EntityLivingBase)) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer) && !this.livingGraves) {
            return;
        }
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        try {
            List drops = event.getDrops();
            EntityLivingBase entity = (EntityLivingBase)event.getEntity();
            DeathPosition deathPos = new DeathPosition(entity);
            if (deathPos.placeGraveStone(drops)) {
                event.setCanceled(true);
            }
            if (this.givePlayerNote) {
                deathPos.givePlayerNote();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDeath(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        if (!Tools.keepInventory(player)) {
            return;
        }
        try {
            DeathPosition.givePlayerNote(player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void playerJoin(EntityJoinWorldEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        if (!event.getWorld().field_72995_K) {
            return;
        }
        final EntityPlayer player = (EntityPlayer)event.getEntity();
        if (player.field_70128_L) {
            return;
        }
        if (!this.checkUpdates) {
            return;
        }
        if (this.updateShown) {
            return;
        }
        UpdateChecker checker = new UpdateChecker(new UpdateChecker.IUpdateCheckResult(){

            @Override
            public void onResult(boolean isAvailable) {
                if (isAvailable) {
                    String msg = "[" + new TextComponentTranslation("message.name", new Object[0]).func_150254_d() + "] " + new TextComponentTranslation("message.update", new Object[0]).func_150254_d() + " ";
                    ClickEvent openUrl = new ClickEvent(ClickEvent.Action.OPEN_URL, "http://minecraft.curseforge.com/projects/gravestone-mod");
                    Style style = new Style();
                    style.func_150241_a(openUrl);
                    style.func_150228_d(Boolean.valueOf(true));
                    style.func_150238_a(TextFormatting.GREEN);
                    style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(new TextComponentTranslation("message.update.hover", new Object[0]).func_150254_d())));
                    TextComponentString comp = new TextComponentString("[Download]");
                    comp.func_150255_a(style);
                    player.func_145747_a(new TextComponentString(msg).func_150257_a((ITextComponent)comp));
                }
            }
        }, 18, "http://maxhenkel.de/update/gravestone_1.10.2.txt");
        checker.start();
        this.updateShown = true;
    }
}

