/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.TileEntityGraveStone;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelHumanoidHead;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TileentitySpecialRendererGraveStone
extends TileEntitySpecialRenderer<TileEntityGraveStone> {
    public static final String KEY_RENDER_SKULL = "render_skull";
    private boolean renderSkull = Main.getInstance().getConfig().getBoolean("render_skull", true);
    private HashMap<String, GameProfile> players = new HashMap();

    public void renderTileEntityAt(TileEntityGraveStone target, double x, double y, double z, float partialTicks, int destroyStage) {
        String name = target.getPlayerName();
        if (name == null || name.isEmpty()) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.0f), (float)((float)z + 0.5f));
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.getDirection(target.func_145832_p())), (float)0.0f, (float)1.0f, (float)0.0f);
        FontRenderer renderer = this.func_147498_b();
        if (renderer != null) {
            int textWidth = renderer.func_78256_a(name);
            float textScale = 0.8f / (float)textWidth;
            textScale = Math.min(textScale, 0.02f);
            GL11.glTranslatef((float)(-(textScale * (float)textWidth) / 2.0f), (float)0.3f, (float)0.37f);
            GL11.glScalef((float)textScale, (float)textScale, (float)textScale);
            GL11.glDepthMask((boolean)false);
            renderer.func_78276_b(name, 0, 0, 0);
            GL11.glDepthMask((boolean)true);
        }
        GL11.glPopMatrix();
        boolean render = false;
        IBlockState state = target.func_145831_w().func_180495_p(target.func_174877_v().func_177977_b());
        if (state == null) {
            return;
        }
        Block block = state.func_177230_c();
        if (block == null) {
            return;
        }
        if (block.func_176214_u()) {
            render = true;
        }
        if (target.renderHead() && target.getPlayerUUID() != null && !target.getPlayerUUID().isEmpty() && this.renderSkull && render) {
            this.renderSkull(x, y, z, target.getPlayerUUID(), target.getPlayerName(), target.func_145832_p());
        }
    }

    public void renderSkull(double x, double y, double z, String uuid, String name, int rotation) {
        ModelHumanoidHead modelbase = new ModelHumanoidHead();
        ResourceLocation resourcelocation = DefaultPlayerSkin.func_177335_a();
        if (uuid != null) {
            GameProfile profile = this.getGameProfile(uuid, name);
            Minecraft minecraft = Minecraft.func_71410_x();
            Map map = minecraft.func_152342_ad().func_152788_a(profile);
            if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
            } else {
                UUID id = EntityPlayer.func_146094_a((GameProfile)profile);
                resourcelocation = DefaultPlayerSkin.func_177334_a((UUID)id);
            }
        }
        this.func_147499_a(resourcelocation);
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
        float yaw = 26.0f;
        float pitch = -61.0f;
        float scale = 0.0625f;
        GL11.glRotatef((float)(180 - this.getDirection(rotation)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.14f, (float)-0.18f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        modelbase.func_78088_a((Entity)null, 0.0f, 0.0f, 0.0f, yaw, pitch, scale);
        GlStateManager.func_179121_F();
    }

    public GameProfile getGameProfile(String uuid, String name) {
        if (this.players.containsKey(uuid)) {
            return this.players.get(uuid);
        }
        GameProfile profile = TileEntitySkull.func_174884_b((GameProfile)new GameProfile(UUID.fromString(uuid), name));
        this.players.put(uuid, profile);
        return profile;
    }

    private int getDirection(int i) {
        switch (i) {
            case 2: {
                return 0;
            }
            case 4: {
                return 90;
            }
            case 3: {
                return 180;
            }
            case 5: {
                return 270;
            }
        }
        return 0;
    }
}

