/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.gui;

import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.Tools;
import de.maxhenkel.gravestone.gui.PageList;
import java.io.IOException;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class GUIDeathItems
extends GuiScreen {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("gravestone", "textures/gui/info.png");
    private static final int TEXTURE_X = 163;
    private static final int TEXTURE_Y = 165;
    private EntityPlayer player;
    private DeathInfo info;
    private GuiButton buttonPrev;
    private GuiButton buttonNext;
    private int page;
    private PageList pageList;

    public GUIDeathItems(EntityPlayer player, DeathInfo info) {
        this.player = player;
        this.info = info;
        this.page = 0;
        this.pageList = new PageList(info.getItems(), this);
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        int left = (this.field_146294_l - 163) / 2;
        this.buttonPrev = this.func_189646_b(new GuiButton(0, left, 190, 75, 20, Tools.translate("button.prev")));
        this.buttonNext = this.func_189646_b(new GuiButton(1, left + 163 - 75, 190, 75, 20, Tools.translate("button.next")));
        this.buttonPrev.field_146124_l = false;
        if (this.pageList.getPages() <= 0) {
            this.buttonNext.field_146124_l = false;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                --this.page;
                if (this.page < 0) {
                    this.page = 0;
                }
            } else if (button.field_146127_k == 1) {
                ++this.page;
                if (this.page > this.pageList.getPages()) {
                    this.page = this.pageList.getPages();
                }
            }
        }
        this.buttonPrev.field_146124_l = this.page > 0;
        this.buttonNext.field_146124_l = this.page < this.pageList.getPages();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int left = (this.field_146294_l - 163) / 2;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.func_73729_b(left, 20, 0, 0, 163, 165);
        if (this.page == 0) {
            this.drawFirstPage(mouseX, mouseY);
        } else if (this.page > 0 && this.pageList.getPages() >= this.page - 1) {
            this.pageList.drawPage(this.page - 1);
        }
    }

    public void drawFirstPage(int mouseX, int mouseY) {
        int left = (this.field_146294_l - 163) / 2;
        int offset = 5;
        int offsetLeft = left + offset;
        String title = Tools.translate("gui.deathinfo.title");
        int titleWidth = this.field_146289_q.func_78256_a(title);
        this.field_146289_q.func_78276_b(TextFormatting.BLACK + "" + TextFormatting.UNDERLINE + title, (this.field_146294_l - titleWidth) / 2, 30, 0);
        String textName = Tools.translate("gui.deathinfo.name") + ":";
        this.drawLeft(TextFormatting.BLACK + textName, 50);
        String name = this.info.getName();
        this.drawRight(TextFormatting.DARK_GRAY + name, 50);
        String textDimension = Tools.translate("gui.deathinfo.dimension") + ":";
        this.drawLeft(TextFormatting.BLACK + textDimension, 63);
        String dimension = Tools.dimIDToString(this.info.getDimension());
        this.drawRight(TextFormatting.DARK_GRAY + dimension, 63);
        String textTime = Tools.translate("gui.deathinfo.time") + ":";
        this.drawLeft(TextFormatting.BLACK + textTime, 76);
        String time = Tools.timeToString(this.info.getTime());
        this.drawRight(TextFormatting.DARK_GRAY + time, 76);
        String textLocation = Tools.translate("gui.deathinfo.location") + ":";
        this.drawLeft(TextFormatting.BLACK + textLocation, 89);
        String locX = "X: " + this.info.getDeathLocation().func_177958_n();
        String locY = "Y: " + this.info.getDeathLocation().func_177956_o();
        String locZ = "Z: " + this.info.getDeathLocation().func_177952_p();
        this.drawRight(TextFormatting.DARK_GRAY + locX, 89);
        this.drawRight(TextFormatting.DARK_GRAY + locY, 102);
        this.drawRight(TextFormatting.DARK_GRAY + locZ, 115);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiInventory.func_147046_a((int)(this.field_146294_l / 2), (int)175, (int)30, (float)(this.field_146294_l / 2 - mouseX), (float)(100 - mouseY), (EntityLivingBase)this.field_146297_k.field_71439_g);
    }

    public void drawItem(String string, int height) {
        int left = (this.field_146294_l - 163) / 2;
        int offset = 40;
        int offsetLeft = left + offset;
        this.field_146289_q.func_78276_b(string, offsetLeft, height, 0);
    }

    public void drawItemSize(String string, int height) {
        int left = (this.field_146294_l - 163) / 2;
        int offset = 15;
        int offsetLeft = left + offset;
        this.field_146289_q.func_78276_b(string, offsetLeft, height, 0);
    }

    public void drawLeft(String string, int height) {
        int left = (this.field_146294_l - 163) / 2;
        int offset = 7;
        int offsetLeft = left + offset;
        this.field_146289_q.func_78276_b(string, offsetLeft, height, 0);
    }

    public void drawRight(String string, int height) {
        int left = (this.field_146294_l - 163) / 2;
        int offset = 14;
        int offsetLeft = left + offset;
        int strWidth = this.field_146289_q.func_78256_a(string);
        this.field_146289_q.func_78276_b(string, left + 163 - strWidth - offset, height, 0);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }
}

