/*
 * Decompiled with CFR 0.152.
 */
package pcl.OpenFM;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pcl.OpenFM.CommonProxy;
import pcl.OpenFM.ContentRegistry;
import pcl.OpenFM.GUI.OFMGuiHandler;
import pcl.OpenFM.Handler.ClientEvent;
import pcl.OpenFM.Handler.ServerEvent;
import pcl.OpenFM.OFMConfiguration;
import pcl.OpenFM.network.PacketHandler;
import pcl.OpenFM.player.PlayerDispatcher;

@Mod(modid="openfm", name="OpenFM", version="0.1.0.11", dependencies="", guiFactory="pcl.OpenFM.GUI.OFMGuiFactory", acceptedMinecraftVersions="[1.9.4]")
public class OpenFM {
    public static final String MODID = "openfm";
    @Mod.Instance(value="openfm")
    public static OpenFM instance;
    @SidedProxy(clientSide="pcl.OpenFM.ClientProxy", serverSide="pcl.OpenFM.CommonProxy")
    public static CommonProxy proxy;
    public static List<PlayerDispatcher> playerList;
    public Configuration config;
    public static final Logger logger;
    public static File configFile;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PacketHandler.init();
        configFile = new File(event.getModConfigurationDirectory() + "/openfm/openfm.cfg");
        OFMConfiguration.init(configFile);
        if (event.getSourceFile().getName().endsWith(".jar") && event.getSide().isClient() && OFMConfiguration.enableMUD) {
            logger.info("Registering mod with OpenUpdater.");
            try {
                Class.forName("pcl.mud.OpenUpdater").getDeclaredMethod("registerMod", ModContainer.class, URL.class, URL.class).invoke(null, FMLCommonHandler.instance().findContainerFor((Object)this), new URL("http://PC-Logix.com/OpenFM/get_latest_build.php?mcver=1.7.10"), new URL("http://PC-Logix.com/OpenFM/changelog.php?mcver=1.7.10"));
            }
            catch (Throwable e) {
                logger.info("OpenUpdater is not installed, not registering.");
            }
        }
        ContentRegistry.init();
        proxy.initTileEntities();
        proxy.registerItemRenderers();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new OFMGuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvent());
        FMLCommonHandler.instance().bus().register((Object)new ClientEvent());
        MinecraftForge.EVENT_BUS.register((Object)new ServerEvent());
        FMLCommonHandler.instance().bus().register((Object)new ServerEvent());
        FMLCommonHandler.instance().bus().register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)instance);
        proxy.registerRenderers();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals(MODID)) {
            OFMConfiguration.sync();
        }
    }

    public static void killAllStreams() {
        if (playerList != null) {
            for (PlayerDispatcher p : playerList) {
                p.stop();
            }
        }
    }

    static {
        playerList = new ArrayList<PlayerDispatcher>();
        logger = LogManager.getFormatterLogger((String)MODID);
    }
}

