/*
 * Decompiled with CFR 0.152.
 */
package pcl.OpenFM.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pcl.OpenFM.OpenFM;
import pcl.OpenFM.network.message.BaseRadioMessage;

public class MessageRadioBase
implements IMessage {
    BaseRadioMessage message;
    private static int id = 0;
    private static Map<Integer, Class<? extends BaseRadioMessage>> idmap = new HashMap<Integer, Class<? extends BaseRadioMessage>>();
    private static Map<Class<? extends BaseRadioMessage>, Integer> msgmap = new HashMap<Class<? extends BaseRadioMessage>, Integer>();

    public static void registerMessage(Class<? extends BaseRadioMessage> message) {
        idmap.put(id, message);
        msgmap.put(message, id++);
    }

    public MessageRadioBase() {
    }

    public MessageRadioBase(BaseRadioMessage message) {
        this.message = message;
    }

    public void fromBytes(ByteBuf buf) {
        int id = buf.readInt();
        if (idmap.containsKey(id)) {
            Class<? extends BaseRadioMessage> radioMessage = idmap.get(id);
            try {
                this.message = radioMessage.newInstance();
                this.message.fromBytes(buf);
            }
            catch (IllegalAccessException | InstantiationException e) {
                OpenFM.logger.error("Failed to create instance of " + radioMessage.getSimpleName(), (Throwable)e);
            }
        } else {
            OpenFM.logger.error("No radio message for ID: " + id);
        }
    }

    public void toBytes(ByteBuf buf) {
        if (this.message != null) {
            buf.writeInt(msgmap.get(this.message.getClass()).intValue());
            this.message.toBytes(buf);
        } else {
            buf.writeInt(-1);
        }
    }
}

