/*
 * Decompiled with CFR 0.152.
 */
package pcl.OpenFM.player;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import pcl.OpenFM.OpenFM;
import pcl.OpenFM.network.PacketHandler;
import pcl.OpenFM.network.message.MessageRadioPlaying;

public class OGGPlayer {
    private final Deque<SourceDataLine> linesPlaying = new ConcurrentLinkedDeque<SourceDataLine>();
    private float volume = 0.0f;
    private int posX;
    private int posY;
    private int posZ;
    private World world;
    private String streamURL;
    private SourceDataLine line;

    public void play(String streamURL) throws IOException {
        this.streamURL = streamURL;
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(streamURL).build();
        Response response = client.newCall(request).execute();
        InputStream stream = response.body().byteStream();
        BufferedInputStream bis = new BufferedInputStream(response.body().byteStream());
        try (AudioInputStream in = AudioSystem.getAudioInputStream(bis);){
            AudioFormat outFormat = this.getOutFormat(in.getFormat());
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, outFormat);
            try (SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);){
                this.line = line;
                if (line != null) {
                    line.open(outFormat);
                    this.linesPlaying.add(line);
                    line.start();
                    this.stream(AudioSystem.getAudioInputStream(outFormat, in), line);
                    line.drain();
                    line.stop();
                    this.linesPlaying.remove(line);
                }
            }
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageRadioPlaying(this.posX, this.posY, this.posZ, false).wrap());
            FMLClientHandler.instance().getClient().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"msg.OpenFM.invalid_link")));
            OpenFM.logger.error((Object)e);
            throw new IllegalStateException(e);
        }
    }

    private AudioFormat getOutFormat(AudioFormat inFormat) {
        int ch = inFormat.getChannels();
        float rate = inFormat.getSampleRate();
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, rate, 16, ch, ch * 2, rate, false);
    }

    private void stream(AudioInputStream in, SourceDataLine line) throws IOException {
        byte[] buffer = new byte[65536];
        int n = 0;
        while (n != -1) {
            line.write(buffer, 0, n);
            n = in.read(buffer, 0, buffer.length);
        }
    }

    public void stop() {
        while (this.linesPlaying.peek() != null) {
            SourceDataLine line = this.linesPlaying.pop();
            Throwable throwable = null;
            try {
                line.stop();
                this.linesPlaying.clear();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (line == null) continue;
                if (throwable != null) {
                    try {
                        line.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                line.close();
            }
        }
    }

    public void setVolume(float f) {
        this.volume = f;
        if (this.line != null && this.line.isOpen()) {
            try {
                FloatControl volumeControl = (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
                if (this.volume == 0.0f) {
                    volumeControl.setValue(volumeControl.getMinimum());
                } else {
                    float minimum = volumeControl.getMinimum();
                    float maximum = volumeControl.getMaximum();
                    double db = Math.log10(this.volume) * 20.0;
                    volumeControl.setValue(Math.max(minimum, Math.min(maximum, (float)db)));
                }
            }
            catch (IllegalArgumentException iae) {
                throw new RuntimeException(iae);
            }
        }
    }

    public float getVolume() {
        return this.volume;
    }

    public void setID(World world, int x, int y, int z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.world = world;
    }

    public boolean isPlaying() {
        return !this.linesPlaying.isEmpty();
    }
}

