/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.chameleon.block;

import com.jaquadro.minecraft.chameleon.block.tiledata.TileDataShim;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class ChamTileEntity
extends TileEntity {
    private NBTTagCompound failureSnapshot;
    private List<TileDataShim> fixedShims;
    private List<TileDataShim> portableShims;

    public boolean hasDataPacket() {
        return true;
    }

    public boolean dataPacketRequiresRenderUpdate() {
        return false;
    }

    public void injectData(TileDataShim shim) {
        if (this.fixedShims == null) {
            this.fixedShims = new ArrayList<TileDataShim>();
        }
        this.fixedShims.add(shim);
    }

    public void injectPortableData(TileDataShim shim) {
        if (this.portableShims == null) {
            this.portableShims = new ArrayList<TileDataShim>();
        }
        this.portableShims.add(shim);
    }

    public final void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.failureSnapshot = null;
        try {
            if (this.fixedShims != null) {
                for (TileDataShim shim : this.fixedShims) {
                    shim.readFromNBT(tag);
                }
            }
            this.readFromFixedNBT(tag);
            if (this.portableShims != null) {
                for (TileDataShim shim : this.portableShims) {
                    shim.readFromNBT(tag);
                }
            }
            this.readFromPortableNBT(tag);
        }
        catch (Throwable t) {
            this.trapLoadFailure(t, tag);
        }
    }

    public final NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.failureSnapshot != null) {
            this.restoreLoadFailure(tag);
            return tag;
        }
        try {
            if (this.fixedShims != null) {
                for (TileDataShim shim : this.fixedShims) {
                    tag = shim.writeToNBT(tag);
                }
            }
            tag = this.writeToFixedNBT(tag);
            if (this.portableShims != null) {
                for (TileDataShim shim : this.portableShims) {
                    tag = shim.writeToNBT(tag);
                }
            }
            tag = this.writeToPortableNBT(tag);
        }
        catch (Throwable t) {
            FMLLog.log((String)"Chameleon", (Level)Level.ERROR, (Throwable)t, (String)"Tile Save Failure.", (Object[])new Object[0]);
        }
        return tag;
    }

    public void readFromPortableNBT(NBTTagCompound tag) {
    }

    public NBTTagCompound writeToPortableNBT(NBTTagCompound tag) {
        return tag;
    }

    protected void readFromFixedNBT(NBTTagCompound tag) {
    }

    protected NBTTagCompound writeToFixedNBT(NBTTagCompound tag) {
        return tag;
    }

    private void trapLoadFailure(Throwable t, NBTTagCompound tag) {
        this.failureSnapshot = tag.func_74737_b();
        FMLLog.log((String)"Chameleon", (Level)Level.ERROR, (Throwable)t, (String)"Tile Load Failure.", (Object[])new Object[0]);
    }

    private void restoreLoadFailure(NBTTagCompound tag) {
        for (String key : this.failureSnapshot.func_150296_c()) {
            if (tag.func_74764_b(key)) continue;
            tag.func_74782_a(key, this.failureSnapshot.func_74781_a(key).func_74737_b());
        }
    }

    protected boolean loadDidFail() {
        return this.failureSnapshot != null;
    }

    public final NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return tag;
    }

    public final SPacketUpdateTileEntity func_189518_D_() {
        return this.hasDataPacket() ? new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_()) : null;
    }

    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (pkt != null && pkt.func_148857_g() != null) {
            this.func_145839_a(pkt.func_148857_g());
        }
        if (this.dataPacketRequiresRenderUpdate() && this.func_145831_w().field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public void markBlockForUpdate() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public void markBlockForRenderUpdate() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }
}

