/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.chameleon.render;

import com.jaquadro.minecraft.chameleon.render.ChamRender;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;

public class ChamRenderManager {
    private final ReentrantLock lock;
    private WorldVertexBufferUploader vboUploader = new WorldVertexBufferUploader();
    private Stack<ChamRender> freeRenderers = new Stack();
    private Map<VertexBuffer, ChamRender> renderers = new HashMap<VertexBuffer, ChamRender>();
    public static final ChamRenderManager instance = new ChamRenderManager();

    public ChamRenderManager() {
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChamRender getRenderer(VertexBuffer buffer) {
        this.lock.lock();
        try {
            if (buffer != null && this.renderers.containsKey(buffer)) {
                ChamRender chamRender = this.renderers.get(buffer);
                return chamRender;
            }
            if (this.freeRenderers.empty()) {
                this.freeRenderers.push(new ChamRender());
            }
            ChamRender renderer = this.freeRenderers.pop();
            renderer.setVertexBuffer(buffer);
            if (buffer != null) {
                this.renderers.put(buffer, renderer);
            }
            ChamRender chamRender = renderer;
            return chamRender;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void releaseRenderer(ChamRender renderer) {
        this.lock.lock();
        try {
            if (renderer.getVertexBuffer() != null) {
                this.renderers.remove(renderer.getVertexBuffer());
            }
            renderer.setVertexBuffer(null);
            this.freeRenderers.push(renderer);
        }
        finally {
            this.lock.unlock();
        }
    }

    public ChamRender startDrawing(VertexBuffer buffer) {
        return this.startDrawing(buffer, DefaultVertexFormats.field_176599_b);
    }

    public ChamRender startDrawing(VertexBuffer buffer, VertexFormat format) {
        ChamRender renderer = this.getRenderer(buffer);
        try {
            buffer.func_181668_a(7, format);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishDrawing(ChamRender renderer) {
        this.lock.lock();
        try {
            VertexBuffer worldRenderer = renderer.getVertexBuffer();
            if (worldRenderer == null) {
                return;
            }
            try {
                worldRenderer.func_178977_d();
                this.vboUploader.func_181679_a(worldRenderer);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            renderer.setVertexBuffer(null);
            this.renderers.remove(worldRenderer);
            this.freeRenderers.push(renderer);
        }
        finally {
            this.lock.unlock();
        }
    }
}

