/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.solarfluxreborn.init;

import com.google.common.collect.Lists;
import com.mrdimka.solarfluxreborn.config.ModConfiguration;
import com.mrdimka.solarfluxreborn.items.CraftingItem;
import com.mrdimka.solarfluxreborn.items.UpgradeItem;
import com.mrdimka.solarfluxreborn.utility.Lang;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ModItems {
    public static final Item mirror = new CraftingItem("mirror");
    public static final Item solarCell1 = new CraftingItem("solarCell1");
    public static final Item solarCell2 = new CraftingItem("solarCell2");
    public static final Item solarCell3 = new CraftingItem("solarCell3");
    public static final Item solarCell4 = new CraftingItem("solarCell4");
    public static Item mUpgradeBlank;
    public static Item mUpgradeEfficiency;
    public static Item mUpgradeLowLight;
    public static Item mUpgradeTraversal;
    public static Item mUpgradeTransferRate;
    public static Item mUpgradeCapacity;
    public static Item mUpgradeFurnace;

    private ModItems() {
    }

    public static void initialize() {
        ArrayList infos;
        GameRegistry.registerItem((Item)mirror, (String)"mirror");
        GameRegistry.registerItem((Item)solarCell1, (String)"solarCell1");
        GameRegistry.registerItem((Item)solarCell2, (String)"solarCell2");
        GameRegistry.registerItem((Item)solarCell3, (String)"solarCell3");
        GameRegistry.registerItem((Item)solarCell4, (String)"solarCell4");
        boolean anyUpgrade = false;
        if (ModConfiguration.isEfficiencyUpgradeActive()) {
            infos = Lists.newArrayList();
            infos.add(String.format(Lang.localise("upgrade.efficiency"), Float.valueOf(ModConfiguration.getEfficiencyUpgradeIncrease() * 100.0f)));
            infos.add(ModItems.localiseReturnsToScale(ModConfiguration.getEfficiencyUpgradeReturnsToScale()));
            mUpgradeEfficiency = new UpgradeItem("upgradeEfficiency", ModConfiguration.getEfficiencyUpgradeMax(), infos);
            GameRegistry.registerItem((Item)mUpgradeEfficiency, (String)"upgradeEfficiency");
            anyUpgrade = true;
        }
        if (ModConfiguration.isLowLightUpgradeActive()) {
            mUpgradeLowLight = new UpgradeItem("upgradeLowLight", ModConfiguration.getLowLightUpgradeMax(), Lists.newArrayList((Object[])new String[]{Lang.localise("upgrade.low.light")}));
            GameRegistry.registerItem((Item)mUpgradeLowLight, (String)"upgradeLowLight");
            anyUpgrade = true;
        }
        if (ModConfiguration.isTraversalUpgradeActive()) {
            mUpgradeTraversal = new UpgradeItem("upgradeTraversal", ModConfiguration.getTraversalUpgradeMax(), Lists.newArrayList((Object[])new String[]{String.format(Lang.localise("upgrade.traversal"), ModConfiguration.getTraversalUpgradeIncrease())}));
            GameRegistry.registerItem((Item)mUpgradeTraversal, (String)"upgradeTraversal");
            anyUpgrade = true;
        }
        if (ModConfiguration.isTransferRateUpgradeActive()) {
            infos = Lists.newArrayList();
            infos.add(String.format(Lang.localise("upgrade.transfer"), Float.valueOf(ModConfiguration.getTransferRateUpgradeIncrease() * 100.0f)));
            infos.add(ModItems.localiseReturnsToScale(ModConfiguration.getTransferRateUpgradeReturnsToScale()));
            mUpgradeTransferRate = new UpgradeItem("upgradeTransferRate", ModConfiguration.getTransferRateUpgradeMax(), infos);
            GameRegistry.registerItem((Item)mUpgradeTransferRate, (String)"upgradeTransferRate");
            anyUpgrade = true;
        }
        if (ModConfiguration.isCapacityUpgradeActive()) {
            infos = Lists.newArrayList();
            infos.add(String.format(Lang.localise("upgrade.capacity"), Float.valueOf(ModConfiguration.getCapacityUpgradeIncrease() * 100.0f)));
            infos.add(ModItems.localiseReturnsToScale(ModConfiguration.getCapacityUpgradeReturnsToScale()));
            mUpgradeCapacity = new UpgradeItem("upgradeCapacity", ModConfiguration.getCapacityUpgradeMax(), infos);
            GameRegistry.registerItem((Item)mUpgradeCapacity, (String)"upgradeCapacity");
            anyUpgrade = true;
        }
        if (ModConfiguration.isFurnaceUpgradeActive()) {
            mUpgradeFurnace = new UpgradeItem("upgradeFurnace", 1, Lists.newArrayList((Object[])new String[]{Lang.localise("upgrade.furnace")}));
            GameRegistry.registerItem((Item)mUpgradeFurnace, (String)"upgradeFurnace");
            anyUpgrade = true;
        }
        if (anyUpgrade) {
            mUpgradeBlank = new CraftingItem("upgradeBlank");
            GameRegistry.registerItem((Item)mUpgradeBlank, (String)"upgradeBlank");
        }
    }

    private static String localiseReturnsToScale(float pValue) {
        if (pValue < 1.0f) {
            return Lang.localise("decreasingReturnsToScale");
        }
        if (pValue > 1.0f) {
            return Lang.localise("increasingReturnsToScale");
        }
        return Lang.localise("constantReturnsToScale");
    }
}

