/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.solarfluxreborn.intr.tesla;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;

public class TeslaAPI {
    public static Class ITeslaConsumer = TeslaAPI.teslaClassExists("ITeslaConsumer");
    public static Class ITeslaHolder = TeslaAPI.teslaClassExists("ITeslaHolder");
    public static Class ITeslaProducer = TeslaAPI.teslaClassExists("ITeslaProducer");
    public static final List<Class> classes = new ArrayList<Class>();
    public static final List<String> allClasses = new ArrayList<String>();

    public static int refreshTeslaClassData() {
        allClasses.clear();
        classes.clear();
        ITeslaConsumer = TeslaAPI.teslaClassExists("ITeslaConsumer");
        ITeslaHolder = TeslaAPI.teslaClassExists("ITeslaHolder");
        ITeslaProducer = TeslaAPI.teslaClassExists("ITeslaProducer");
        return classes.size();
    }

    public static Class teslaClassExists(String api) {
        try {
            String cn = "net.darkhax.tesla.api." + api;
            allClasses.add(cn);
            Class<?> c = Class.forName(cn);
            classes.add(c);
            return c;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean isTeslaConsumer(TileEntity tile) {
        return ITeslaConsumer != null && tile != null ? tile.getClass().isAssignableFrom(ITeslaConsumer) : false;
    }

    public static boolean isTeslaHolder(TileEntity tile) {
        return ITeslaHolder != null && tile != null ? tile.getClass().isAssignableFrom(ITeslaHolder) : false;
    }

    public static boolean isTeslaProducer(TileEntity tile) {
        return ITeslaProducer != null && tile != null ? tile.getClass().isAssignableFrom(ITeslaProducer) : false;
    }

    public static long givePowerToConsumer(TileEntity consumer, long power, boolean simulated) {
        if (TeslaAPI.isTeslaConsumer(consumer)) {
            try {
                Method givePower = consumer.getClass().getMethod("givePower", Long.TYPE, Boolean.TYPE);
                return (Long)givePower.invoke((Object)consumer, power, simulated);
            }
            catch (Throwable err) {
                err.printStackTrace();
            }
        }
        return 0L;
    }

    public static long getStoredPowerInHolder(TileEntity holder) {
        if (TeslaAPI.isTeslaHolder(holder)) {
            try {
                Method givePower = holder.getClass().getMethod("getStoredPower", new Class[0]);
                return (Long)givePower.invoke((Object)holder, new Object[0]);
            }
            catch (Throwable err) {
                err.printStackTrace();
            }
        }
        return 0L;
    }

    public static long getCapacityPowerInHolder(TileEntity holder) {
        if (TeslaAPI.isTeslaHolder(holder)) {
            try {
                Method givePower = holder.getClass().getMethod("getCapacity", new Class[0]);
                return (Long)givePower.invoke((Object)holder, new Object[0]);
            }
            catch (Throwable err) {
                err.printStackTrace();
            }
        }
        return 0L;
    }

    public static long takePowerFromProducer(TileEntity producer, long power, boolean simulated) {
        if (TeslaAPI.isTeslaProducer(producer)) {
            try {
                Method givePower = producer.getClass().getMethod("takePower", Long.TYPE, Boolean.TYPE);
                return (Long)givePower.invoke((Object)producer, power, simulated);
            }
            catch (Throwable err) {
                err.printStackTrace();
            }
        }
        return 0L;
    }
}

