/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.solarfluxreborn.te;

import cofh.api.energy.IEnergyProvider;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.mrdimka.common.utils.CommonTileEntity_SFR;
import com.mrdimka.solarfluxreborn.InventoryNonTile2;
import com.mrdimka.solarfluxreborn.blocks.StatefulEnergyStorage;
import com.mrdimka.solarfluxreborn.blocks.modules.EnergySharingModule;
import com.mrdimka.solarfluxreborn.blocks.modules.ITileEntityModule;
import com.mrdimka.solarfluxreborn.blocks.modules.SimpleEnergyDispenserModule;
import com.mrdimka.solarfluxreborn.blocks.modules.TraversalEnergyDispenserModule;
import com.mrdimka.solarfluxreborn.config.ModConfiguration;
import com.mrdimka.solarfluxreborn.config.TierConfiguration;
import com.mrdimka.solarfluxreborn.init.ModItems;
import com.mrdimka.solarfluxreborn.items.UpgradeItem;
import com.mrdimka.solarfluxreborn.utility.Utils;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class SolarPanelTileEntity
extends CommonTileEntity_SFR
implements IInventory,
IEnergyProvider {
    public static final int INVENTORY_SIZE = 5;
    public static final Range<Integer> UPGRADE_SLOTS = Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(5));
    private final StatefulEnergyStorage mEnergyStorage;
    private int mTierIndex;
    private ITileEntityModule mEnergySharingModule;
    private ITileEntityModule mEnergyDispenserModule = new SimpleEnergyDispenserModule(this);
    private int mCurrentEnergyGeneration;
    private float mSunIntensity;
    private InventoryNonTile2 mInventory = new InventoryNonTile2(5);
    private Map<Item, Integer> mUpgradeCache = Maps.newHashMap();

    public InventoryNonTile2 getInventory() {
        return this.mInventory;
    }

    public SolarPanelTileEntity() {
        this(0);
    }

    public int getTier() {
        return this.mTierIndex;
    }

    public SolarPanelTileEntity(int pTierIndex) {
        this.mTierIndex = pTierIndex;
        this.mEnergyStorage = new StatefulEnergyStorage(ModConfiguration.getTierConfiguration(this.mTierIndex).getCapacity(), ModConfiguration.getTierConfiguration(this.mTierIndex).getMaximumEnergyTransfer());
        if (ModConfiguration.doesAutoBalanceEnergy()) {
            this.mEnergySharingModule = new EnergySharingModule(this);
        }
    }

    public TierConfiguration getTierConfiguration() {
        return ModConfiguration.getTierConfigurations().get(this.mTierIndex);
    }

    public void func_73660_a() {
        this.updateCurrentEnergyGeneration(Utils.isServer(this.field_145850_b) ? this.field_174879_c.func_177984_a() : this.field_174879_c);
        if (!this.field_145850_b.field_72995_K) {
            this.mEnergyDispenserModule.tick();
            this.generateEnergy();
            if (this.mEnergySharingModule != null) {
                this.mEnergySharingModule.tick();
            }
            if (this.atTickRate(20)) {
                this.func_70296_d();
            }
        }
    }

    public StatefulEnergyStorage getEnergyStorage() {
        return this.mEnergyStorage;
    }

    public int getCurrentEnergyGeneration() {
        return this.mCurrentEnergyGeneration;
    }

    public void setCurrentEnergyGeneration(int pCurrentEnergyGeneration) {
        this.mCurrentEnergyGeneration = pCurrentEnergyGeneration;
    }

    public int getMaximumEnergyGeneration() {
        return this.getTierConfiguration().getMaximumEnergyGeneration();
    }

    public void updateCurrentEnergyGeneration(BlockPos pos) {
        this.computeSunIntensity(pos);
        double energyGeneration = (float)this.getMaximumEnergyGeneration() * this.mSunIntensity;
        this.mCurrentEnergyGeneration = (int)Math.round(energyGeneration *= 1.0 + (double)ModConfiguration.getEfficiencyUpgradeIncrease() * Math.pow(this.getUpgradeCount(ModItems.mUpgradeEfficiency), ModConfiguration.getEfficiencyUpgradeReturnsToScale()));
    }

    public float getSunIntensity() {
        return this.mSunIntensity;
    }

    public void setSunIntensity(float pSunIntensity) {
        this.mSunIntensity = pSunIntensity;
    }

    public void computeSunIntensity(BlockPos at) {
        if (this.field_145850_b.func_175710_j(at)) {
            float multiplicator = 1.5f - (float)this.getUpgradeCount(ModItems.mUpgradeLowLight) * 0.122f;
            float displacement = 1.2f + (float)this.getUpgradeCount(ModItems.mUpgradeLowLight) * 0.08f;
            float celestialAngleRadians = this.field_145850_b.func_72929_e(1.0f);
            if ((double)celestialAngleRadians > Math.PI) {
                celestialAngleRadians = (float)(Math.PI * 2 - (double)celestialAngleRadians);
            }
            this.mSunIntensity = multiplicator * MathHelper.func_76134_b((float)(celestialAngleRadians / displacement));
            this.mSunIntensity = Math.max(0.0f, this.mSunIntensity);
            this.mSunIntensity = Math.min(1.0f, this.mSunIntensity);
            if (this.mSunIntensity > 0.0f) {
                if (this.field_145850_b.func_72896_J()) {
                    this.mSunIntensity *= ModConfiguration.getRainGenerationFactor();
                }
                if (this.field_145850_b.func_72911_I()) {
                    this.mSunIntensity *= ModConfiguration.getThunderGenerationFactor();
                }
            }
        } else {
            this.mSunIntensity = 0.0f;
        }
    }

    protected void generateEnergy() {
        if (this.mCurrentEnergyGeneration > 0) {
            this.getEnergyStorage().receiveEnergy(this.mCurrentEnergyGeneration, false);
        }
    }

    private void refreshUpgradeCache() {
        this.mUpgradeCache.clear();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack == null || !(itemStack.func_77973_b() instanceof UpgradeItem)) continue;
            if (this.mUpgradeCache.containsKey(itemStack.func_77973_b())) {
                this.mUpgradeCache.put(itemStack.func_77973_b(), itemStack.field_77994_a + this.mUpgradeCache.get(itemStack.func_77973_b()));
                continue;
            }
            this.mUpgradeCache.put(itemStack.func_77973_b(), itemStack.field_77994_a);
        }
        if (this.getUpgradeCount(ModItems.mUpgradeTraversal) > 0 && this.mEnergyDispenserModule instanceof SimpleEnergyDispenserModule) {
            this.mEnergyDispenserModule = new TraversalEnergyDispenserModule(this);
        } else if (this.getUpgradeCount(ModItems.mUpgradeTraversal) == 0 && this.mEnergyDispenserModule instanceof TraversalEnergyDispenserModule) {
            this.mEnergyDispenserModule = new SimpleEnergyDispenserModule(this);
        }
        this.getEnergyStorage().setMaxTransfer((int)((double)ModConfiguration.getTierConfiguration(this.mTierIndex).getMaximumEnergyTransfer() * (1.0 + (double)ModConfiguration.getTransferRateUpgradeIncrease() * Math.pow(this.getUpgradeCount(ModItems.mUpgradeTransferRate), ModConfiguration.getTransferRateUpgradeReturnsToScale()))));
        this.getEnergyStorage().setMaxEnergyStored((int)((double)ModConfiguration.getTierConfiguration(this.mTierIndex).getCapacity() * (1.0 + (double)ModConfiguration.getCapacityUpgradeIncrease() * Math.pow(this.getUpgradeCount(ModItems.mUpgradeCapacity), ModConfiguration.getCapacityUpgradeReturnsToScale()))));
    }

    public int getTotalUpgradeInstalled() {
        int count = 0;
        for (int value : this.mUpgradeCache.values()) {
            count += value;
        }
        return count;
    }

    public int additionalUpgradeAllowed(ItemStack pItemStack) {
        Item item;
        if (pItemStack != null && (item = pItemStack.func_77973_b()) instanceof UpgradeItem) {
            UpgradeItem upgrade = (UpgradeItem)item;
            return upgrade.getMaximumPerSolarPanel() - this.getUpgradeCount(upgrade);
        }
        return 0;
    }

    public int getUpgradeCount(Item pItem) {
        if (pItem != null) {
            Integer count = this.mUpgradeCache.get(pItem);
            return count == null ? 0 : count;
        }
        return 0;
    }

    protected void loadDataFromNBT(NBTTagCompound pNBT) {
        this.mTierIndex = pNBT.func_74762_e("SFTierIndex");
        this.mEnergyStorage.setMaxEnergyStored(ModConfiguration.getTierConfiguration(this.mTierIndex).getCapacity());
        this.mEnergyStorage.setMaxTransfer(ModConfiguration.getTierConfiguration(this.mTierIndex).getMaximumEnergyTransfer());
        if (!pNBT.func_74767_n("ClientIgnoredInv")) {
            this.mInventory.readFromNBT(pNBT);
        }
        this.mEnergyStorage.readFromNBT(pNBT);
    }

    protected void addDataToNBT(NBTTagCompound pNBT) {
        pNBT.func_74768_a("SFTierIndex", this.mTierIndex);
        this.mInventory.writeToNBT(pNBT);
        this.mEnergyStorage.writeToNBT(pNBT);
    }

    @Override
    public boolean canConnectEnergy(EnumFacing pFrom) {
        return pFrom != EnumFacing.UP;
    }

    @Override
    public int extractEnergy(EnumFacing pFrom, int pMaxExtract, boolean pSimulate) {
        return this.getEnergyStorage().extractEnergy(this.getEnergyStorage().getMaxExtract(), pSimulate);
    }

    public int getEnergyStored() {
        return this.getEnergyStored(EnumFacing.DOWN);
    }

    public void setEnergyStored(int pEnergy) {
        this.getEnergyStorage().setEnergyStored(pEnergy);
    }

    public double getScaledEnergyStoredFraction(int pScale) {
        double v = pScale;
        v *= (double)this.getEnergyStored();
        return v /= (double)this.getMaxEnergyStored();
    }

    public int getPercentageEnergyStored() {
        return (int)this.getScaledEnergyStoredFraction(100);
    }

    @Override
    public int getEnergyStored(EnumFacing pFrom) {
        return this.getEnergyStorage().getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStored(EnumFacing.DOWN);
    }

    @Override
    public int getMaxEnergyStored(EnumFacing pFrom) {
        return this.getEnergyStorage().getMaxEnergyStored();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("hash", this.hashCode()).add("MaxProduction", this.getMaximumEnergyGeneration()).add("energyStorage", (Object)this.getEnergyStorage()).toString();
    }

    public int func_70302_i_() {
        return this.mInventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int pSlotIndex) {
        return this.mInventory.func_70301_a(pSlotIndex);
    }

    public ItemStack func_70298_a(int pSlotIndex, int pDecrementAmount) {
        return this.mInventory.func_70298_a(pSlotIndex, pDecrementAmount);
    }

    public void func_70299_a(int pSlotIndex, ItemStack pItemStack) {
        this.mInventory.func_70299_a(pSlotIndex, pItemStack);
    }

    public int func_70297_j_() {
        return this.mInventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer pEntityPlayer) {
        return this.mInventory.func_70300_a(pEntityPlayer);
    }

    public boolean func_94041_b(int pSlotIndex, ItemStack pItemStack) {
        if (pItemStack.func_77973_b() instanceof UpgradeItem && this.additionalUpgradeAllowed(pItemStack) >= pItemStack.field_77994_a) {
            return this.mInventory.func_94041_b(pSlotIndex, pItemStack);
        }
        return false;
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        this.refreshUpgradeCache();
    }

    public ITextComponent func_145748_c_() {
        return this.mInventory.func_145748_c_();
    }

    public String func_70005_c_() {
        return this.mInventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.mInventory.func_145818_k_();
    }

    public void func_174888_l() {
        this.mInventory.func_174888_l();
    }

    public void func_174886_c(EntityPlayer arg0) {
        this.mInventory.func_174886_c(arg0);
    }

    public int func_174887_a_(int arg0) {
        return this.mInventory.func_174887_a_(arg0);
    }

    public int func_174890_g() {
        return this.mInventory.func_174890_g();
    }

    public void func_174889_b(EntityPlayer arg0) {
        this.mInventory.func_174889_b(arg0);
    }

    public ItemStack func_70304_b(int arg0) {
        return this.mInventory.func_70304_b(arg0);
    }

    public void func_174885_b(int arg0, int arg1) {
        this.mInventory.func_174885_b(arg0, arg1);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        this.loadDataFromNBT(nbt);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("SFTierIndex", this.mTierIndex);
        this.mInventory.writeToNBT(nbt);
        this.mEnergyStorage.writeToNBT(nbt);
    }
}

