/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.client.gui.guide;

import com.valkyrieofnight.valkyrielib.gui.client.VLGuiContainer;
import com.valkyrieofnight.valkyrielib.gui.client.elements.VLElement;
import com.valkyrieofnight.valkyrielib.gui.client.elements.VLElementContainer;
import com.valkyrieofnight.valkyrielib.util.TextureLoc;
import com.valkyrieofnight.valkyrielib.util.helpers.ColorUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuidePageGeneric
extends VLElementContainer {
    private List<StringDetails> strings = new ArrayList<StringDetails>();
    private List<ItemDetails> items = new ArrayList<ItemDetails>();
    private List<TextureLoc> images = new ArrayList<TextureLoc>();

    public GuidePageGeneric(String elementAddress, VLGuiContainer gui, int x, int y) {
        super(elementAddress, gui, x, y);
    }

    public GuidePageGeneric(VLGuiContainer gui, int x, int y) {
        super(gui, x, y);
    }

    public void mouseClicked(VLElement e) {
    }

    public void addMainTitle(String str, int x, int y) {
        this.strings.add(new StringDetails(StringDetails.EnumType.NORMAL, ColorUtil.BOLD + ColorUtil.UNDERLINE + str, x, y, -1, ColorUtil.MC_BLACK_A));
    }

    public void addTitle(String str, int x, int y) {
        this.strings.add(new StringDetails(StringDetails.EnumType.NORMAL, ColorUtil.UNDERLINE + str, x, y, -1, ColorUtil.MC_BLACK_A));
    }

    public void addString(String str, int x, int y) {
        this.strings.add(new StringDetails(StringDetails.EnumType.NORMAL, str, x, y, -1, ColorUtil.MC_BLACK_A));
    }

    public void addString(String str, int x, int y, int color) {
        this.strings.add(new StringDetails(StringDetails.EnumType.NORMAL, str, x, y, -1, color));
    }

    public void addStringWrapped(String str, int x, int y, int maxWidth, int color) {
        this.strings.add(new StringDetails(StringDetails.EnumType.WRAPPED, str, x, y, maxWidth, color));
    }

    public void addStringCentered(String str, int x, int y, int color) {
        this.strings.add(new StringDetails(StringDetails.EnumType.CENTERED, str, x, y, -1, color));
    }

    public void addItem(ItemStack item, int x, int y) {
        this.items.add(new ItemDetails(item, x, y));
    }

    protected void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY, int guiLeft, int guiTop) {
        super.drawBackgroundLayer(partialTicks, mouseX, mouseY, guiLeft, guiTop);
        for (StringDetails sd : this.strings) {
            int sx = guiLeft + sd.x;
            int sy = guiTop + sd.y;
            if (sd.type == StringDetails.EnumType.NORMAL) {
                this.gui.getFontRenderer().func_78276_b(sd.text, sx, sy, sd.color);
                continue;
            }
            if (sd.type == StringDetails.EnumType.CENTERED) {
                this.gui.func_73732_a(this.gui.getFontRenderer(), sd.text, sx, sy, sd.color);
                continue;
            }
            this.gui.getFontRenderer().func_78279_b(sd.text, sx, sy, sd.wrapWidth, sd.color);
        }
        RenderHelper.func_74520_c();
        for (ItemDetails itemDetails : this.items) {
            this.gui.getItemRenderer().func_180450_b(itemDetails.item, guiLeft + itemDetails.x, guiTop + itemDetails.y);
        }
        RenderHelper.func_74518_a();
    }

    public void drawToolTip(int mouseX, int mouseY, int guiLeft, int guiTop) {
        super.drawToolTip(mouseX, mouseY, guiLeft, guiTop);
        for (ItemDetails itemDetails : this.items) {
            if (!this.isMouseInBox(mouseX, mouseY, guiLeft + itemDetails.x, guiTop + itemDetails.y, guiLeft + itemDetails.x + 16, guiTop + itemDetails.y + 16)) continue;
            this.gui.drawHoveringText(itemDetails.item.func_82840_a(this.gui.getPlayer(), false));
        }
    }

    private static class ItemDetails {
        public final ItemStack item;
        public final int x;
        public final int y;

        public ItemDetails(ItemStack itm, int x, int y) {
            this.item = itm;
            this.x = x;
            this.y = y;
        }
    }

    private static class StringDetails {
        public final String text;
        public final int x;
        public final int y;
        public final int wrapWidth;
        public EnumType type;
        public final int color;

        private StringDetails(String text, int x, int y, EnumType type, int wrapWidth, int color) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.wrapWidth = wrapWidth;
            this.type = type;
            this.color = color;
        }

        public StringDetails(EnumType type, String text, int x, int y, int wrapWidth, int color) {
            this(text, x, y, type, wrapWidth, color);
        }

        protected static enum EnumType {
            NORMAL,
            WRAPPED,
            CENTERED;

        }
    }
}

