/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.init;

import com.valkyrieofnight.environmentaltech.api.registry.ETRegistries;
import com.valkyrieofnight.environmentaltech.api.registry.IFocusableRegistry;
import com.valkyrieofnight.environmentaltech.api.util.WeightedItemStack;
import com.valkyrieofnight.environmentaltech.api.util.WeightedOreStack;
import com.valkyrieofnight.environmentaltech.init.ETBlocks;
import com.valkyrieofnight.environmentaltech.init.ETItems;
import com.valkyrieofnight.environmentaltech.registry.terraformer.TerraformerSoftwareRegistry;
import com.valkyrieofnight.environmentaltech.registry.terraformer.software.SoftwareDeforrest;
import com.valkyrieofnight.environmentaltech.registry.terraformer.software.SoftwareGrassGrower;
import com.valkyrieofnight.environmentaltech.registry.terraformer.software.SoftwarePlantRemover;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public class ETCommonRecipes {
    private static ETBlocks etb;
    private static ETItems eti;
    private static TerraformerSoftwareRegistry tfr;

    public static void preInit() {
        tfr.registerSoftware(SoftwareDeforrest.getInstance());
        tfr.registerSoftware(SoftwarePlantRemover.getInstance());
        tfr.registerSoftware(SoftwareGrassGrower.getInstance());
    }

    public static void initialize() {
    }

    public static void postInit() {
        ETCommonRecipes.addVoidOreMinerRecipes();
        ETCommonRecipes.addVoidResMinerRecipes();
    }

    public static void addVoidOreMinerRecipes() {
        ResourceLocation dimOreRL;
        IFocusableRegistry reg = ETRegistries.voidOreMinerRegistry;
        reg.addResource(new WeightedOreStack("oreCoal", 40), EnumDyeColor.BLACK);
        reg.addResource(new WeightedOreStack("oreIron", 32), EnumDyeColor.WHITE);
        reg.addResource(new WeightedOreStack("oreQuartz", 20), EnumDyeColor.WHITE);
        reg.addResource(new WeightedOreStack("oreRedstone", 20), EnumDyeColor.RED);
        reg.addResource(new WeightedOreStack("oreLapis", 16), EnumDyeColor.BLUE);
        reg.addResource(new WeightedOreStack("oreGold", 14), EnumDyeColor.YELLOW);
        reg.addResource(new WeightedOreStack("oreDiamond", 11), EnumDyeColor.CYAN);
        reg.addResource(new WeightedOreStack("oreEmerald", 5), EnumDyeColor.LIME);
        reg.addResource(new WeightedOreStack("glowstone", 7), EnumDyeColor.YELLOW);
        reg.addResource(new WeightedOreStack("shardLonsdaleite", 6), EnumDyeColor.BLACK);
        reg.addResource(new WeightedOreStack("oreCopper", 26), EnumDyeColor.ORANGE);
        reg.addResource(new WeightedOreStack("oreTin", 26), EnumDyeColor.GRAY);
        reg.addResource(new WeightedOreStack("oreSilver", 20), EnumDyeColor.SILVER);
        reg.addResource(new WeightedOreStack("oreLead", 22), EnumDyeColor.PURPLE);
        reg.addResource(new WeightedOreStack("oreAluminum", 20), EnumDyeColor.WHITE);
        reg.addResource(new WeightedOreStack("oreUranium", 6), EnumDyeColor.GREEN);
        reg.addResource(new WeightedOreStack("oreYellorite", 6), EnumDyeColor.GREEN);
        reg.addResource(new WeightedOreStack("oreCertusQuartz", 8), EnumDyeColor.LIGHT_BLUE);
        reg.addResource(new WeightedOreStack("oreChargedCertusQuartz", 4), EnumDyeColor.LIGHT_BLUE);
        reg.addResource(new WeightedOreStack("oreCinnabar", 10), EnumDyeColor.BROWN);
        reg.addResource(new WeightedOreStack("oreAmber", 9), EnumDyeColor.ORANGE);
        reg.addResource(new WeightedOreStack("oreNickel", 9), EnumDyeColor.GRAY);
        reg.addResource(new WeightedOreStack("orePlatinum", 6), EnumDyeColor.LIGHT_BLUE);
        reg.addResource(new WeightedOreStack("oreMithril", 6), EnumDyeColor.LIGHT_BLUE);
        reg.addResource(new WeightedOreStack("oreSulfur", 10), EnumDyeColor.YELLOW);
        reg.addResource(new WeightedOreStack("oreNiter", 10), EnumDyeColor.WHITE);
        reg.addResource(new WeightedOreStack("oreSaltpeter", 8), EnumDyeColor.WHITE);
        reg.addResource(new WeightedOreStack("oreFirestone", 6), EnumDyeColor.RED);
        reg.addResource(new WeightedOreStack("oreCobalt", 8), EnumDyeColor.BLUE);
        reg.addResource(new WeightedOreStack("oreArdite", 8), EnumDyeColor.ORANGE);
        reg.addResource(new WeightedOreStack("oreApatite", 10), EnumDyeColor.LIGHT_BLUE);
        reg.addResource(new WeightedOreStack("oreDraconium", 6), EnumDyeColor.PURPLE);
        reg.addResource(new WeightedOreStack("oreGraphite", 12), EnumDyeColor.BLACK);
        reg.addResource(new WeightedOreStack("oreQuartzBlack", 14), EnumDyeColor.BLACK);
        reg.addResource(new WeightedOreStack("oreRuby", 10), EnumDyeColor.RED);
        reg.addResource(new WeightedOreStack("orePeridot", 8), EnumDyeColor.GREEN);
        reg.addResource(new WeightedOreStack("oreTopaz", 8), EnumDyeColor.ORANGE);
        reg.addResource(new WeightedOreStack("oreTanzanite", 8), EnumDyeColor.PURPLE);
        reg.addResource(new WeightedOreStack("oreMalachite", 8), EnumDyeColor.CYAN);
        reg.addResource(new WeightedOreStack("oreSapphire", 8), EnumDyeColor.LIGHT_BLUE);
        reg.addResource(new WeightedOreStack("oreResonating", 6), EnumDyeColor.BROWN);
        reg.addResource(new WeightedOreStack("oreZinc", 9), EnumDyeColor.PINK);
        reg.addResource(new WeightedOreStack("oreIridium", 6), EnumDyeColor.WHITE);
        reg.addResource(new WeightedOreStack("oreTungsten", 8), EnumDyeColor.BLACK);
        if (Loader.isModLoaded((String)"rftools") && (dimOreRL = new ResourceLocation("rftools", "dimensional_shard_ore")) != null) {
            ItemStack dimOre = new ItemStack((Block)Block.field_149771_c.func_82594_a((Object)dimOreRL));
            reg.addResource(new WeightedItemStack(dimOre, 4), EnumDyeColor.WHITE);
        }
    }

    public static void addVoidResMinerRecipes() {
        IFocusableRegistry reg = ETRegistries.voidResMinerRegistry;
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150348_b, 1, 0), 16), EnumDyeColor.GRAY);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150348_b, 1, 1), 14), EnumDyeColor.PINK);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150348_b, 1, 3), 14), EnumDyeColor.WHITE);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150348_b, 1, 5), 14), EnumDyeColor.GRAY);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150351_n, 1, 0), 14), EnumDyeColor.SILVER);
        reg.addResource(new WeightedItemStack(new ItemStack((Block)Blocks.field_150349_c, 1, 0), 6), EnumDyeColor.GREEN);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150346_d, 1, 0), 14), EnumDyeColor.BROWN);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150346_d, 1, 2), 6), EnumDyeColor.BROWN);
        reg.addResource(new WeightedItemStack(new ItemStack((Block)Blocks.field_150354_m, 1, 0), 14), EnumDyeColor.YELLOW);
        reg.addResource(new WeightedItemStack(new ItemStack((Block)Blocks.field_150354_m, 1, 1), 10), EnumDyeColor.ORANGE);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150347_e, 1, 0), 14), EnumDyeColor.GRAY);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150341_Y, 1, 0), 6), EnumDyeColor.GREEN);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150343_Z, 1, 0), 5), EnumDyeColor.PURPLE);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150435_aG, 1, 0), 7), EnumDyeColor.SILVER);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150424_aL, 1, 0), 14), EnumDyeColor.RED);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150425_aM, 1, 0), 10), EnumDyeColor.BROWN);
        reg.addResource(new WeightedItemStack(new ItemStack((Block)Blocks.field_150391_bh, 1, 0), 4), EnumDyeColor.PURPLE);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150377_bs, 1, 0), 7), EnumDyeColor.WHITE);
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150405_ch, 1, 0), 6), EnumDyeColor.RED);
        for (EnumDyeColor dye : EnumDyeColor.values()) {
            reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150406_ce, 1, dye.func_176765_a()), 1), dye);
        }
        reg.addResource(new WeightedItemStack(new ItemStack(Blocks.field_150360_v, 1, 0), 2), EnumDyeColor.YELLOW);
        reg.addResource(new WeightedItemStack(new ItemStack((Block)ETBlocks.alabaster, 1, 0), 10), EnumDyeColor.WHITE);
        reg.addResource(new WeightedItemStack(new ItemStack((Block)ETBlocks.basalt, 1, 0), 10), EnumDyeColor.BLACK);
        reg.addResource(new WeightedItemStack(new ItemStack((Block)ETBlocks.hardened_stone, 1, 0), 10), EnumDyeColor.GRAY);
        reg.addResource(new WeightedItemStack(new ItemStack((Block)ETBlocks.mica, 1), 2), EnumDyeColor.WHITE);
        reg.addResource(new WeightedOreStack("stoneMarble", 10), EnumDyeColor.WHITE);
        reg.addResource(new WeightedOreStack("stoneLimestone", 10), EnumDyeColor.LIME);
    }

    static {
        tfr = TerraformerSoftwareRegistry.getInstance();
    }
}

