/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.registry.terraformer;

import com.valkyrieofnight.environmentaltech.api.registry.ITerraformerSoftwareRegistry;
import com.valkyrieofnight.environmentaltech.api.registry.terraformer.ITerraformerSoftware;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TerraformerSoftwareRegistry
implements ITerraformerSoftwareRegistry {
    private static TerraformerSoftwareRegistry instance;
    private HashMap<Integer, ITerraformerSoftware> software = new HashMap();
    private int currID;

    public static TerraformerSoftwareRegistry getInstance() {
        if (instance == null) {
            instance = new TerraformerSoftwareRegistry();
        }
        return instance;
    }

    private TerraformerSoftwareRegistry() {
    }

    @Override
    public boolean registerSoftware(ITerraformerSoftware sw) {
        if (sw == null || this.hasSoftware(sw.getID())) {
            return false;
        }
        this.software.put(this.currID++, sw);
        return true;
    }

    @Override
    public boolean hasSoftware(String id) {
        return this.getSoftware(id) != null;
    }

    @Override
    public ITerraformerSoftware getSoftware(String name) {
        for (Integer key : this.software.keySet()) {
            if (!this.software.get(key).getID().equalsIgnoreCase(name)) continue;
            return this.software.get(key);
        }
        return null;
    }

    @Override
    public List<String> getSoftwareNameList() {
        ArrayList<String> swn = new ArrayList<String>();
        for (Integer key : this.software.keySet()) {
            swn.add(this.software.get(key).getID());
        }
        return swn;
    }

    @Override
    public ITerraformerSoftware getSoftware(int id) {
        return this.software.get(id);
    }

    @Override
    public int getSoftwareID(String id) {
        if (this.hasSoftware(id)) {
            for (Integer key : this.software.keySet()) {
                if (this.software.get(key) == null || !this.software.get(key).getID().equalsIgnoreCase(id)) continue;
                return key;
            }
        }
        return 0;
    }

    public ITerraformerSoftware getTypeWithName(Class clazz, String softwareName) {
        ITerraformerSoftware sw = this.getSoftware(softwareName);
        if (clazz.isInstance(sw)) {
            return sw;
        }
        return null;
    }
}

